/*
 * Decompiled with CFR 0.152.
 */
package dev.isxander.yacl3.api;

import dev.isxander.yacl3.gui.image.ImageRenderer;
import dev.isxander.yacl3.impl.OptionDescriptionImpl;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

public interface OptionDescription {
    public static final OptionDescription EMPTY = new OptionDescriptionImpl(CommonComponents.EMPTY, CompletableFuture.completedFuture(Optional.empty()));

    public Component text();

    public CompletableFuture<Optional<ImageRenderer>> image();

    public static Builder createBuilder() {
        return new OptionDescriptionImpl.BuilderImpl();
    }

    public static OptionDescription of(Component ... description) {
        return OptionDescription.createBuilder().text(description).build();
    }

    public static interface Builder {
        public Builder text(Component ... var1);

        public Builder text(Collection<? extends Component> var1);

        public Builder image(ResourceLocation var1, int var2, int var3);

        public Builder image(ResourceLocation var1, float var2, float var3, int var4, int var5, int var6, int var7);

        public Builder image(Path var1, ResourceLocation var2);

        public Builder webpImage(ResourceLocation var1);

        public Builder webpImage(Path var1, ResourceLocation var2);

        public Builder customImage(CompletableFuture<Optional<ImageRenderer>> var1);

        @Deprecated
        public Builder gifImage(ResourceLocation var1);

        @Deprecated
        public Builder gifImage(Path var1, ResourceLocation var2);

        public OptionDescription build();
    }
}

