/*
 * Decompiled with CFR 0.152.
 */
package eu.midnightdust.lib.config;

import com.google.common.collect.Lists;
import com.google.gson.ExclusionStrategy;
import com.google.gson.FieldAttributes;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import eu.midnightdust.lib.util.PlatformFunctions;
import java.awt.Color;
import java.io.Reader;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Field;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.AbstractSliderButton;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.ContainerObjectSelectionList;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.SpriteIconButton;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.components.tabs.GridLayoutTab;
import net.minecraft.client.gui.components.tabs.Tab;
import net.minecraft.client.gui.components.tabs.TabManager;
import net.minecraft.client.gui.components.tabs.TabNavigationBar;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public abstract class MidnightConfig {
    private static final Pattern INTEGER_ONLY = Pattern.compile("(-?[0-9]*)");
    private static final Pattern DECIMAL_ONLY = Pattern.compile("-?(\\d+\\.?\\d*|\\d*\\.?\\d+|\\.)");
    private static final Pattern HEXADECIMAL_ONLY = Pattern.compile("(-?[#0-9a-fA-F]*)");
    private static final List<EntryInfo> entries = new ArrayList<EntryInfo>();
    public static final Map<String, Class<? extends MidnightConfig>> configClass = new HashMap<String, Class<? extends MidnightConfig>>();
    private static Path path;
    private static final Gson gson;

    public static void init(String modid, Class<? extends MidnightConfig> config) {
        path = PlatformFunctions.getConfigDirectory().resolve(modid + ".json");
        configClass.put(modid, config);
        for (Field field : config.getFields()) {
            EntryInfo info = new EntryInfo();
            if ((field.isAnnotationPresent(Entry.class) || field.isAnnotationPresent(Comment.class)) && !field.isAnnotationPresent(Server.class) && !field.isAnnotationPresent(Hidden.class) && PlatformFunctions.isClientEnv()) {
                MidnightConfig.initClient(modid, field, info);
            }
            if (field.isAnnotationPresent(Comment.class)) {
                info.centered = field.getAnnotation(Comment.class).centered();
            }
            if (!field.isAnnotationPresent(Entry.class)) continue;
            try {
                info.defaultValue = field.get(null);
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
        try {
            gson.fromJson((Reader)Files.newBufferedReader(path), config);
        }
        catch (Exception e) {
            MidnightConfig.write(modid);
        }
        for (EntryInfo info : entries) {
            if (!info.field.isAnnotationPresent(Entry.class)) continue;
            try {
                info.value = info.field.get(null);
                info.tempValue = info.value.toString();
            }
            catch (IllegalAccessException illegalAccessException) {}
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void initClient(String modid, Field field, EntryInfo info) {
        Class<?> type = field.getType();
        Entry e = field.getAnnotation(Entry.class);
        info.width = e != null ? e.width() : 0;
        info.field = field;
        info.id = modid;
        if (e != null) {
            if (!e.name().isEmpty()) {
                info.name = Component.translatable((String)e.name());
            }
            if (type == Integer.TYPE) {
                MidnightConfig.textField(info, Integer::parseInt, INTEGER_ONLY, (int)e.min(), (int)e.max(), true);
            } else if (type == Float.TYPE) {
                MidnightConfig.textField(info, Float::parseFloat, DECIMAL_ONLY, (float)e.min(), (float)e.max(), false);
            } else if (type == Double.TYPE) {
                MidnightConfig.textField(info, Double::parseDouble, DECIMAL_ONLY, e.min(), e.max(), false);
            } else if (type == String.class || type == List.class) {
                MidnightConfig.textField(info, String::length, null, Math.min(e.min(), 0.0), Math.max(e.max(), 1.0), true);
            } else if (type == Boolean.TYPE) {
                Function<Object, Component> func = value -> Component.translatable((String)((Boolean)value != false ? "gui.yes" : "gui.no")).withStyle((Boolean)value != false ? ChatFormatting.GREEN : ChatFormatting.RED);
                info.widget = new AbstractMap.SimpleEntry<Button.OnPress, Function<Object, Component>>(button -> {
                    info.value = (Boolean)info.value == false;
                    button.setMessage((Component)func.apply(info.value));
                }, func);
            } else if (type.isEnum()) {
                List<?> values = Arrays.asList(field.getType().getEnumConstants());
                Function<Object, Component> func = value -> Component.translatable((String)(modid + ".midnightconfig.enum." + type.getSimpleName() + "." + info.value.toString()));
                info.widget = new AbstractMap.SimpleEntry<Button.OnPress, Function<Object, Component>>(button -> {
                    int index = values.indexOf(info.value) + 1;
                    info.value = values.get(index >= values.size() ? 0 : index);
                    button.setMessage((Component)func.apply(info.value));
                }, func);
            }
        }
        entries.add(info);
    }

    public static Tooltip getTooltip(EntryInfo info) {
        String key = info.id + ".midnightconfig." + info.field.getName() + ".tooltip";
        return Tooltip.create((Component)(info.error != null ? info.error : (I18n.exists((String)key) ? Component.translatable((String)key) : Component.empty())));
    }

    private static void textField(EntryInfo info, Function<String, Number> f, Pattern pattern, double min, double max, boolean cast) {
        boolean isNumber = pattern != null;
        info.widget = (t, b) -> s -> {
            if (!((String)(s = ((String)s).trim())).isEmpty() && isNumber && !pattern.matcher((CharSequence)s).matches()) {
                return false;
            }
            Number value = 0;
            boolean inLimits = false;
            info.error = null;
            if (!(isNumber && ((String)s).isEmpty() || ((String)s).equals("-") || ((String)s).equals("."))) {
                try {
                    value = (Number)f.apply((String)s);
                }
                catch (NumberFormatException e2) {
                    return false;
                }
                boolean bl = inLimits = value.doubleValue() >= min && value.doubleValue() <= max;
                info.error = inLimits ? null : Component.literal((String)(value.doubleValue() < min ? "\u00a7cMinimum " + (isNumber ? "value" : "length") + (cast ? " is " + (int)min : " is " + min) : "\u00a7cMaximum " + (isNumber ? "value" : "length") + (cast ? " is " + (int)max : " is " + max))).withStyle(ChatFormatting.RED);
                t.setTooltip(MidnightConfig.getTooltip(info));
            }
            info.tempValue = s;
            t.setTextColor(inLimits ? -1 : -34953);
            info.inLimits = inLimits;
            b.active = entries.stream().allMatch(e -> e.inLimits);
            if (inLimits && info.field.getType() != List.class) {
                info.value = isNumber ? value : s;
            } else if (inLimits) {
                if (((List)info.value).size() == info.index) {
                    ((List)info.value).add("");
                }
                ((List)info.value).set(info.index, Arrays.stream(info.tempValue.replace("[", "").replace("]", "").split(", ")).toList().get(0));
            }
            if (info.field.getAnnotation(Entry.class).isColor()) {
                if (!((String)s).contains("#")) {
                    s = "#" + (String)s;
                }
                if (!HEXADECIMAL_ONLY.matcher((CharSequence)s).matches()) {
                    return false;
                }
                try {
                    info.colorButton.setMessage((Component)Component.literal((String)"\u2b1b").setStyle(Style.EMPTY.withColor(Color.decode(info.tempValue).getRGB())));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return true;
        };
    }

    public static MidnightConfig getClass(String modid) {
        try {
            return configClass.get(modid).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static void write(String modid) {
        MidnightConfig.getClass(modid).writeChanges(modid);
    }

    public void writeChanges(String modid) {
        path = PlatformFunctions.getConfigDirectory().resolve(modid + ".json");
        try {
            if (!Files.exists(path, new LinkOption[0])) {
                Files.createFile(path, new FileAttribute[0]);
            }
            Files.write(path, gson.toJson((Object)MidnightConfig.getClass(modid)).getBytes(), new OpenOption[0]);
        }
        catch (Exception e) {
            e.fillInStackTrace();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static Screen getScreen(Screen parent, String modid) {
        return new MidnightConfigScreen(parent, modid);
    }

    static {
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{128}).excludeFieldsWithModifiers(new int[]{2}).addSerializationExclusionStrategy((ExclusionStrategy)new HiddenAnnotationExclusionStrategy()).setPrettyPrinting().create();
    }

    public static class EntryInfo {
        Field field;
        Object widget;
        int width;
        boolean centered;
        Component error;
        Object defaultValue;
        Object value;
        String tempValue;
        boolean inLimits = true;
        String id;
        Component name;
        int index;
        AbstractWidget colorButton;
        Tab tab;
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface Entry {
        public int width() default 100;

        public double min() default 2.2250738585072014E-308;

        public double max() default 1.7976931348623157E308;

        public String name() default "";

        public boolean isColor() default false;

        public boolean isSlider() default false;

        public int precision() default 100;

        public String category() default "default";
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface Comment {
        public boolean centered() default false;

        public String category() default "default";
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface Server {
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface Hidden {
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class MidnightConfigScreen
    extends Screen {
        public final String translationPrefix;
        public final Screen parent;
        public final String modid;
        public MidnightConfigListWidget list;
        public boolean reload = false;
        public TabManager tabManager = new TabManager(a -> {}, a -> {});
        public Map<String, Tab> tabs = new HashMap<String, Tab>();
        public Tab prevTab;
        public TabNavigationBar tabNavigation;
        public Button done;
        public double scrollProgress = 0.0;

        protected MidnightConfigScreen(Screen parent, String modid) {
            super((Component)Component.translatable((String)(modid + ".midnightconfig.title")));
            this.parent = parent;
            this.modid = modid;
            this.translationPrefix = modid + ".midnightconfig.";
            this.loadValues();
            for (EntryInfo e : entries) {
                if (!e.id.equals(modid)) continue;
                String tabId = e.field.isAnnotationPresent(Entry.class) ? e.field.getAnnotation(Entry.class).category() : e.field.getAnnotation(Comment.class).category();
                String name = this.translationPrefix + "category." + tabId;
                if (!I18n.exists((String)name) && tabId.equals("default")) {
                    name = this.translationPrefix + "title";
                }
                if (!this.tabs.containsKey(name)) {
                    GridLayoutTab tab = new GridLayoutTab((Component)Component.translatable((String)name));
                    e.tab = tab;
                    this.tabs.put(name, (Tab)tab);
                    continue;
                }
                e.tab = this.tabs.get(name);
            }
            this.tabNavigation = TabNavigationBar.builder((TabManager)this.tabManager, (int)this.width).addTabs(this.tabs.values().toArray(new Tab[0])).build();
            this.tabNavigation.selectTab(0, false);
            this.tabNavigation.arrangeElements();
            this.prevTab = this.tabManager.getCurrentTab();
        }

        public void tick() {
            super.tick();
            if (this.prevTab != null && this.prevTab != this.tabManager.getCurrentTab()) {
                this.prevTab = this.tabManager.getCurrentTab();
                this.list.clear();
                this.fillList();
                this.list.setScrollAmount(0.0);
            }
            this.scrollProgress = this.list.getScrollAmount();
            for (EntryInfo info : entries) {
                try {
                    info.field.set(null, info.value);
                }
                catch (IllegalAccessException illegalAccessException) {}
            }
            this.updateResetButtons();
        }

        public void updateResetButtons() {
            if (this.list != null) {
                for (ButtonEntry entry : this.list.children()) {
                    AbstractWidget abstractWidget;
                    if (entry.buttons == null || entry.buttons.size() <= 1 || !((abstractWidget = entry.buttons.get(1)) instanceof Button)) continue;
                    Button button = (Button)abstractWidget;
                    button.active = !Objects.equals(entry.info.value.toString(), entry.info.defaultValue.toString());
                }
            }
        }

        public void loadValues() {
            try {
                gson.fromJson((Reader)Files.newBufferedReader(path), configClass.get(this.modid));
            }
            catch (Exception e) {
                MidnightConfig.write(this.modid);
            }
            for (EntryInfo info : entries) {
                if (!info.field.isAnnotationPresent(Entry.class)) continue;
                try {
                    info.value = info.field.get(null);
                    info.tempValue = info.value.toString();
                }
                catch (IllegalAccessException illegalAccessException) {}
            }
        }

        public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
            if (this.tabNavigation.keyPressed(keyCode)) {
                return true;
            }
            return super.keyPressed(keyCode, scanCode, modifiers);
        }

        public void init() {
            super.init();
            this.tabNavigation.setWidth(this.width);
            this.tabNavigation.arrangeElements();
            if (this.tabs.size() > 1) {
                this.addRenderableWidget((GuiEventListener)this.tabNavigation);
            }
            this.addRenderableWidget((GuiEventListener)Button.builder((Component)CommonComponents.GUI_CANCEL, button -> {
                this.loadValues();
                Objects.requireNonNull(this.minecraft).setScreen(this.parent);
            }).bounds(this.width / 2 - 154, this.height - 28, 150, 20).build());
            this.done = (Button)this.addRenderableWidget((GuiEventListener)Button.builder((Component)CommonComponents.GUI_DONE, button -> {
                for (EntryInfo info : entries) {
                    if (!info.id.equals(this.modid)) continue;
                    try {
                        info.field.set(null, info.value);
                    }
                    catch (IllegalAccessException illegalAccessException) {}
                }
                MidnightConfig.write(this.modid);
                Objects.requireNonNull(this.minecraft).setScreen(this.parent);
            }).bounds(this.width / 2 + 4, this.height - 28, 150, 20).build());
            this.list = new MidnightConfigListWidget(this.minecraft, this.width, this.height - 64, 32, 25);
            if (this.minecraft != null && this.minecraft.level != null) {
                this.list.setRenderBackground(false);
            }
            this.addWidget((GuiEventListener)this.list);
            this.fillList();
            this.reload = true;
        }

        public void fillList() {
            for (EntryInfo info : entries) {
                if (info.id.equals(this.modid) && (info.tab == null || info.tab == this.tabManager.getCurrentTab())) {
                    Component name = Objects.requireNonNullElseGet(info.name, () -> Component.translatable((String)(this.translationPrefix + info.field.getName())));
                    SpriteIconButton resetButton = SpriteIconButton.builder((Component)Component.translatable((String)"controls.reset"), button -> {
                        info.value = info.defaultValue;
                        info.tempValue = info.defaultValue.toString();
                        info.index = 0;
                        this.list.clear();
                        this.fillList();
                    }, (boolean)true).sprite(new ResourceLocation("midnightlib", "icon/reset"), 12, 12).size(40, 20).build();
                    resetButton.setPosition(this.width - 205, 0);
                    if (info.widget instanceof Map.Entry) {
                        widget = (Map.Entry)info.widget;
                        if (info.field.getType().isEnum()) {
                            widget.setValue(value -> Component.translatable((String)(this.translationPrefix + "enum." + info.field.getType().getSimpleName() + "." + info.value.toString())));
                        }
                        this.list.addButton(List.of(Button.builder((Component)((Component)((Function)widget.getValue()).apply(info.value)), (Button.OnPress)((Button.OnPress)widget.getKey())).bounds(this.width - 160, 0, 150, 20).tooltip(MidnightConfig.getTooltip(info)).build(), resetButton), name, info);
                    } else if (info.field.getType() == List.class) {
                        if (!this.reload) {
                            info.index = 0;
                        }
                        widget = new EditBox(this.font, this.width - 160, 0, 150, 20, (Component)Component.empty());
                        widget.setMaxLength(info.width);
                        if (info.index < ((List)info.value).size()) {
                            widget.setValue(String.valueOf(((List)info.value).get(info.index)));
                        }
                        Predicate processor = (Predicate)((BiFunction)info.widget).apply(widget, this.done);
                        widget.setFilter(processor);
                        resetButton.setWidth(20);
                        Button cycleButton = Button.builder((Component)Component.literal((String)String.valueOf(info.index)).withStyle(ChatFormatting.GOLD), button -> {
                            if (((List)info.value).contains("")) {
                                ((List)info.value).remove("");
                            }
                            ++info.index;
                            if (info.index > ((List)info.value).size()) {
                                info.index = 0;
                            }
                            this.list.clear();
                            this.fillList();
                        }).bounds(this.width - 185, 0, 20, 20).build();
                        widget.setTooltip(MidnightConfig.getTooltip(info));
                        this.list.addButton(List.of(widget, resetButton, cycleButton), name, info);
                    } else if (info.widget != null) {
                        Entry e = info.field.getAnnotation(Entry.class);
                        widget = e.isSlider() ? new MidnightSliderWidget(this.width - 160, 0, 150, 20, Component.nullToEmpty((String)info.tempValue), (Double.parseDouble(info.tempValue) - e.min()) / (e.max() - e.min()), info) : new EditBox(this.font, this.width - 160, 0, 150, 20, null, Component.nullToEmpty((String)info.tempValue));
                        if (widget instanceof EditBox) {
                            EditBox textField = (EditBox)widget;
                            textField.setMaxLength(info.width);
                            textField.setValue(info.tempValue);
                            Predicate processor = (Predicate)((BiFunction)info.widget).apply(textField, this.done);
                            textField.setFilter(processor);
                        }
                        widget.setTooltip(MidnightConfig.getTooltip(info));
                        if (e.isColor()) {
                            resetButton.setWidth(20);
                            Button colorButton = Button.builder((Component)Component.literal((String)"\u2b1b"), button -> {}).bounds(this.width - 185, 0, 20, 20).build();
                            try {
                                colorButton.setMessage((Component)Component.literal((String)"\u2b1b").setStyle(Style.EMPTY.withColor(Color.decode(info.tempValue).getRGB())));
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            info.colorButton = colorButton;
                            colorButton.active = false;
                            this.list.addButton(List.of(widget, resetButton, colorButton), name, info);
                        } else {
                            this.list.addButton(List.of(widget, resetButton), name, info);
                        }
                    } else {
                        this.list.addButton(List.of(), name, info);
                    }
                }
                this.list.setScrollAmount(this.scrollProgress);
                this.updateResetButtons();
            }
        }

        public void render(GuiGraphics context, int mouseX, int mouseY, float delta) {
            if (this.minecraft != null && this.minecraft.level != null) {
                super.renderTransparentBackground(context);
            }
            this.list.render(context, mouseX, mouseY, delta);
            super.render(context, mouseX, mouseY, delta);
            if (this.tabs.size() < 2) {
                context.drawCenteredString(this.font, this.title, this.width / 2, 15, 0xFFFFFF);
            }
        }

        public void renderBackground(GuiGraphics c, int x, int y, float d) {
        }
    }

    public static class HiddenAnnotationExclusionStrategy
    implements ExclusionStrategy {
        public boolean shouldSkipClass(Class<?> clazz) {
            return false;
        }

        public boolean shouldSkipField(FieldAttributes fieldAttributes) {
            return fieldAttributes.getAnnotation(Entry.class) == null;
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface Client {
    }

    public static class MidnightSliderWidget
    extends AbstractSliderButton {
        private final EntryInfo info;
        private final Entry e;

        public MidnightSliderWidget(int x, int y, int width, int height, Component text, double value, EntryInfo info) {
            super(x, y, width, height, text, value);
            this.e = info.field.getAnnotation(Entry.class);
            this.info = info;
        }

        protected void updateMessage() {
            this.setMessage(Component.nullToEmpty((String)this.info.tempValue));
        }

        protected void applyValue() {
            if (this.info.field.getType() == Integer.TYPE) {
                this.info.value = ((Number)(this.e.min() + this.value * (this.e.max() - this.e.min()))).intValue();
            } else if (this.info.field.getType() == Double.TYPE) {
                this.info.value = (double)Math.round((this.e.min() + this.value * (this.e.max() - this.e.min())) * (double)this.e.precision()) / (double)this.e.precision();
            } else if (this.info.field.getType() == Float.TYPE) {
                this.info.value = Float.valueOf((float)Math.round((this.e.min() + this.value * (this.e.max() - this.e.min())) * (double)this.e.precision()) / (float)this.e.precision());
            }
            this.info.tempValue = String.valueOf(this.info.value);
        }
    }

    public static class ButtonEntry
    extends ContainerObjectSelectionList.Entry<ButtonEntry> {
        private static final Font textRenderer = Minecraft.getInstance().font;
        public final List<AbstractWidget> buttons;
        private final Component text;
        public final EntryInfo info;
        public static final Map<AbstractWidget, Component> buttonsWithText = new HashMap<AbstractWidget, Component>();

        private ButtonEntry(List<AbstractWidget> buttons, Component text, EntryInfo info) {
            if (!buttons.isEmpty()) {
                buttonsWithText.put(buttons.get(0), text);
            }
            this.buttons = buttons;
            this.text = text;
            this.info = info;
        }

        public void render(GuiGraphics context, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean hovered, float tickDelta) {
            this.buttons.forEach(b -> {
                b.setY(y);
                b.render(context, mouseX, mouseY, tickDelta);
            });
            if (!(this.text == null || this.text.getString().contains("spacer") && this.buttons.isEmpty())) {
                if (this.info.centered) {
                    context.drawString(textRenderer, this.text, Minecraft.getInstance().getWindow().getGuiScaledWidth() / 2 - textRenderer.width((FormattedText)this.text) / 2, y + 5, 0xFFFFFF);
                } else {
                    int wrappedY = y;
                    for (FormattedCharSequence orderedText : textRenderer.split((FormattedText)this.text, this.buttons.size() > 1 ? this.buttons.get(1).getX() - 24 : Minecraft.getInstance().getWindow().getGuiScaledWidth() - 24)) {
                        context.drawString(textRenderer, orderedText, 12, wrappedY + 5, 0xFFFFFF);
                        wrappedY += 9;
                    }
                }
            }
        }

        public List<? extends GuiEventListener> children() {
            return Lists.newArrayList(this.buttons);
        }

        public List<? extends NarratableEntry> narratables() {
            return Lists.newArrayList(this.buttons);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class MidnightConfigListWidget
    extends ContainerObjectSelectionList<ButtonEntry> {
        public MidnightConfigListWidget(Minecraft client, int width, int height, int y, int itemHeight) {
            super(client, width, height, y, itemHeight);
        }

        public int getScrollbarPosition() {
            return this.width - 7;
        }

        public void addButton(List<AbstractWidget> buttons, Component text, EntryInfo info) {
            this.addEntry((AbstractSelectionList.Entry)new ButtonEntry(buttons, text, info));
        }

        public void clear() {
            this.clearEntries();
        }

        public int getRowWidth() {
            return 10000;
        }

        protected void renderDecorations(GuiGraphics c, int mouseX, int mouseY) {
            c.setColor(0.25f, 0.25f, 0.25f, 1.0f);
            c.blit(Screen.BACKGROUND_LOCATION, this.getX(), 0, 0.0f, 0.0f, this.width, this.getY(), 32, 32);
            c.blit(Screen.BACKGROUND_LOCATION, this.getX(), this.getBottom(), 0.0f, 0.0f, this.width, this.height, 32, 32);
            c.setColor(1.0f, 1.0f, 1.0f, 1.0f);
            if (this.minecraft == null || this.minecraft.level == null) {
                return;
            }
            c.fillGradient(RenderType.guiOverlay(), this.getX(), this.getY(), this.getRight(), this.getY() + 4, -16777216, 0, 0);
            c.fillGradient(RenderType.guiOverlay(), this.getX(), this.getBottom() - 4, this.getRight(), this.getBottom(), 0, -16777216, 0);
        }
    }
}

