/*
 * Decompiled with CFR 0.152.
 */
package eu.midnightdust.lib.config;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.DoubleArgumentType;
import com.mojang.brigadier.arguments.FloatArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import eu.midnightdust.lib.config.MidnightConfig;
import eu.midnightdust.lib.util.PlatformFunctions;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;

public class AutoCommand {
    public static List<LiteralArgumentBuilder<CommandSourceStack>> commands = new ArrayList<LiteralArgumentBuilder<CommandSourceStack>>();
    final Field entry;
    final String modid;

    public AutoCommand(Field entry, String modid) {
        this.entry = entry;
        this.modid = modid;
    }

    public void register() {
        LiteralArgumentBuilder command = Commands.literal((String)this.modid);
        if (this.entry.getType() == Integer.TYPE) {
            command = (LiteralArgumentBuilder)command.then(((LiteralArgumentBuilder)Commands.literal((String)this.entry.getName()).executes(ctx -> this.getValue((CommandSourceStack)ctx.getSource()))).then(Commands.argument((String)"value", (ArgumentType)IntegerArgumentType.integer((int)((int)this.entry.getAnnotation(MidnightConfig.Entry.class).min()), (int)((int)this.entry.getAnnotation(MidnightConfig.Entry.class).max()))).executes(ctx -> this.setValue((CommandSourceStack)ctx.getSource(), IntegerArgumentType.getInteger((CommandContext)ctx, (String)"value")))));
        } else if (this.entry.getType() == Double.TYPE) {
            command = (LiteralArgumentBuilder)command.then(((LiteralArgumentBuilder)Commands.literal((String)this.entry.getName()).executes(ctx -> this.getValue((CommandSourceStack)ctx.getSource()))).then(Commands.argument((String)"value", (ArgumentType)DoubleArgumentType.doubleArg((double)this.entry.getAnnotation(MidnightConfig.Entry.class).min(), (double)this.entry.getAnnotation(MidnightConfig.Entry.class).max())).executes(ctx -> this.setValue((CommandSourceStack)ctx.getSource(), DoubleArgumentType.getDouble((CommandContext)ctx, (String)"value")))));
        } else if (this.entry.getType() == Float.TYPE) {
            command = (LiteralArgumentBuilder)command.then(((LiteralArgumentBuilder)Commands.literal((String)this.entry.getName()).executes(ctx -> this.getValue((CommandSourceStack)ctx.getSource()))).then(Commands.argument((String)"value", (ArgumentType)FloatArgumentType.floatArg((float)((float)this.entry.getAnnotation(MidnightConfig.Entry.class).min()), (float)((float)this.entry.getAnnotation(MidnightConfig.Entry.class).max()))).executes(ctx -> this.setValue((CommandSourceStack)ctx.getSource(), Float.valueOf(FloatArgumentType.getFloat((CommandContext)ctx, (String)"value"))))));
        } else if (this.entry.getType() == Boolean.TYPE) {
            for (i = 0; i < 2; ++i) {
                command = (LiteralArgumentBuilder)command.then(((LiteralArgumentBuilder)Commands.literal((String)this.entry.getName()).executes(ctx -> this.getValue((CommandSourceStack)ctx.getSource()))).then(Commands.literal((String)(i == 0 ? "true" : "false")).executes(ctx -> this.setValue((CommandSourceStack)ctx.getSource(), ctx.getInput().endsWith("true")))));
            }
        } else if (this.entry.getType().isEnum()) {
            for (i = 0; i < this.entry.getType().getEnumConstants().length; ++i) {
                Object enumValue = Arrays.stream(this.entry.getType().getEnumConstants()).toList().get(i);
                command = (LiteralArgumentBuilder)command.then(((LiteralArgumentBuilder)Commands.literal((String)this.entry.getName()).executes(ctx -> this.getValue((CommandSourceStack)ctx.getSource()))).then(Commands.literal((String)enumValue.toString()).executes(ctx -> this.setValue((CommandSourceStack)ctx.getSource(), enumValue))));
            }
        } else if (this.entry.getType() == List.class) {
            for (i = 0; i < 2; ++i) {
                int finalI = i;
                command = (LiteralArgumentBuilder)command.then(((LiteralArgumentBuilder)Commands.literal((String)this.entry.getName()).executes(ctx -> this.getValue((CommandSourceStack)ctx.getSource()))).then(Commands.literal((String)(i == 0 ? "add" : "remove")).then(Commands.argument((String)"value", (ArgumentType)StringArgumentType.string()).executes(ctx -> this.setList((CommandSourceStack)ctx.getSource(), StringArgumentType.getString((CommandContext)ctx, (String)"value"), finalI == 0)))));
            }
        } else {
            command = (LiteralArgumentBuilder)command.then(((LiteralArgumentBuilder)Commands.literal((String)this.entry.getName()).executes(ctx -> this.getValue((CommandSourceStack)ctx.getSource()))).then(Commands.argument((String)"value", (ArgumentType)StringArgumentType.string()).executes(ctx -> this.setValue((CommandSourceStack)ctx.getSource(), StringArgumentType.getString((CommandContext)ctx, (String)"value")))));
        }
        LiteralArgumentBuilder finalized = (LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"midnightconfig").requires(source -> source.hasPermission(2))).then((ArgumentBuilder)command);
        PlatformFunctions.registerCommand((LiteralArgumentBuilder<CommandSourceStack>)finalized);
        commands.add((LiteralArgumentBuilder<CommandSourceStack>)finalized);
    }

    private int setValue(CommandSourceStack source, Object value) {
        try {
            if (this.entry.getType() != List.class) {
                this.entry.set(null, value);
            }
            MidnightConfig.write(this.modid);
        }
        catch (Exception e) {
            source.sendFailure((Component)Component.literal((String)("Could not set " + this.entry.getName() + " to value " + value + ": " + e)));
            return 0;
        }
        source.sendSuccess(() -> Component.literal((String)("Successfully set " + this.entry.getName() + " to " + value)), true);
        return 1;
    }

    private int setList(CommandSourceStack source, String value, boolean add) {
        try {
            List e = (List)this.entry.get(null);
            if (add) {
                e.add(value);
            } else {
                if (!e.contains(value)) {
                    throw new IllegalArgumentException("List does not contain this string!");
                }
                e.remove(value);
            }
            MidnightConfig.write(this.modid);
        }
        catch (Exception e) {
            source.sendFailure((Component)Component.literal((String)((add ? "Could not add " + value + " to " : "Could not remove " + value + " from ") + this.entry.getName() + ": " + e)));
            return 0;
        }
        source.sendSuccess(() -> Component.literal((String)((add ? "Successfully added " + value + " to " : "Successfully removed " + value + " from ") + this.entry.getName())), true);
        return 1;
    }

    private int getValue(CommandSourceStack source) {
        source.sendSuccess(() -> {
            try {
                return Component.literal((String)("The value of " + this.entry.getName() + " is " + this.entry.get(null)));
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }, true);
        return 0;
    }
}

