/*
 * Decompiled with CFR 0.152.
 */
package malte0811.ferritecore.util;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.client.renderer.block.model.multipart.Condition;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;

public class PredicateHelper {
    public static List<Predicate<BlockState>> toCanonicalList(Iterable<? extends Condition> conditions, StateDefinition<Block, BlockState> stateContainer) {
        ArrayList<Predicate<BlockState>> list = new ArrayList<Predicate<BlockState>>();
        for (Condition condition : conditions) {
            list.add(condition.getPredicate(stateContainer));
        }
        PredicateHelper.canonize(list);
        return list;
    }

    public static <T> void canonize(List<Predicate<T>> input) {
        input.sort(Comparator.comparingInt(Object::hashCode));
        if (input instanceof ArrayList) {
            ArrayList arrayList = (ArrayList)input;
            arrayList.trimToSize();
        }
    }

    public static <T> Predicate<T> and(List<Predicate<T>> list) {
        return state -> {
            for (Predicate predicate : list) {
                if (predicate.test(state)) continue;
                return false;
            }
            return true;
        };
    }

    public static <T> Predicate<T> or(List<Predicate<T>> list) {
        return state -> {
            for (Predicate predicate : list) {
                if (!predicate.test(state)) continue;
                return true;
            }
            return false;
        };
    }
}

