/*
 * Decompiled with CFR 0.152.
 */
package malte0811.ferritecore.fastmap;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import it.unimi.dsi.fastutil.objects.Reference2ObjectOpenHashMap;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Map;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;

public abstract class PropertyIndexer<T extends Comparable<T>> {
    private static final Map<Property<?>, PropertyIndexer<?>> KNOWN_INDEXERS = new Reference2ObjectOpenHashMap();
    private final Property<T> property;
    private final int numValues;
    protected final T[] valuesInOrder;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T extends Comparable<T>> PropertyIndexer<T> makeIndexer(Property<T> prop) {
        Map<Property<?>, PropertyIndexer<?>> map = KNOWN_INDEXERS;
        synchronized (map) {
            PropertyIndexer unchecked = KNOWN_INDEXERS.computeIfAbsent(prop, propInner -> {
                PropertyIndexer result = null;
                if (propInner instanceof BooleanProperty) {
                    BooleanProperty boolProp = (BooleanProperty)propInner;
                    result = new BoolIndexer(boolProp);
                } else if (propInner instanceof IntegerProperty) {
                    IntegerProperty intProp = (IntegerProperty)propInner;
                    result = new IntIndexer(intProp);
                } else if (WeirdVanillaDirectionIndexer.isApplicable(propInner)) {
                    result = new WeirdVanillaDirectionIndexer((Property<Direction>)propInner);
                } else if (propInner instanceof EnumProperty) {
                    EnumProperty enumProp = (EnumProperty)propInner;
                    result = new EnumIndexer(enumProp);
                }
                if (result == null || !result.isValid()) {
                    return new GenericIndexer(propInner);
                }
                return result;
            });
            return unchecked;
        }
    }

    protected PropertyIndexer(Property<T> property, T[] valuesInOrder) {
        this.property = property;
        this.numValues = property.getPossibleValues().size();
        this.valuesInOrder = valuesInOrder;
    }

    public Property<T> getProperty() {
        return this.property;
    }

    public int numValues() {
        return this.numValues;
    }

    @Nullable
    public final T byIndex(int index) {
        if (index >= 0 && index < this.valuesInOrder.length) {
            return this.valuesInOrder[index];
        }
        return null;
    }

    public abstract int toIndex(T var1);

    protected boolean isValid() {
        Collection allowed = this.getProperty().getPossibleValues();
        int index = 0;
        for (Comparable val : allowed) {
            if (this.toIndex(val) != index || !val.equals(this.byIndex(index))) {
                return false;
            }
            ++index;
        }
        return true;
    }

    private static class BoolIndexer
    extends PropertyIndexer<Boolean> {
        private static final Boolean[] VALUES = new Boolean[]{true, false};

        protected BoolIndexer(BooleanProperty property) {
            super((Property)property, (Comparable[])VALUES);
        }

        @Override
        public int toIndex(Boolean value) {
            return value != false ? 0 : 1;
        }
    }

    private static class IntIndexer
    extends PropertyIndexer<Integer> {
        private final int min;

        protected IntIndexer(IntegerProperty property) {
            super((Property)property, (Comparable[])property.getPossibleValues().toArray(new Integer[0]));
            this.min = property.getPossibleValues().stream().min(Comparator.naturalOrder()).orElse(0);
        }

        @Override
        public int toIndex(Integer value) {
            return value - this.min;
        }
    }

    private static class WeirdVanillaDirectionIndexer
    extends PropertyIndexer<Direction> {
        private static final Direction[] ORDER = new Direction[]{Direction.NORTH, Direction.EAST, Direction.SOUTH, Direction.WEST, Direction.UP, Direction.DOWN};

        public WeirdVanillaDirectionIndexer(Property<Direction> prop) {
            super(prop, (Comparable[])ORDER);
            Preconditions.checkState((boolean)this.isValid());
        }

        static boolean isApplicable(Property<?> prop) {
            Collection values = prop.getPossibleValues();
            if (values.size() != ORDER.length) {
                return false;
            }
            return Arrays.equals(ORDER, values.toArray());
        }

        @Override
        public int toIndex(Direction value) {
            return switch (value) {
                default -> throw new IncompatibleClassChangeError();
                case Direction.NORTH -> 0;
                case Direction.EAST -> 1;
                case Direction.SOUTH -> 2;
                case Direction.WEST -> 3;
                case Direction.UP -> 4;
                case Direction.DOWN -> 5;
            };
        }
    }

    private static class EnumIndexer<E extends Enum<E>>
    extends PropertyIndexer<E> {
        private final int ordinalOffset;

        protected EnumIndexer(EnumProperty<E> property) {
            super(property, (Comparable[])property.getPossibleValues().toArray(new Enum[0]));
            this.ordinalOffset = property.getPossibleValues().stream().mapToInt(rec$ -> ((Enum)rec$).ordinal()).min().orElse(0);
        }

        @Override
        public int toIndex(E value) {
            return ((Enum)value).ordinal() - this.ordinalOffset;
        }
    }

    private static class GenericIndexer<T extends Comparable<T>>
    extends PropertyIndexer<T> {
        private final Map<Comparable<?>, Integer> toValueIndex;

        protected GenericIndexer(Property<T> property) {
            super(property, property.getPossibleValues().toArray(new Comparable[0]));
            ImmutableMap.Builder toValueIndex = ImmutableMap.builder();
            for (int i = 0; i < this.valuesInOrder.length; ++i) {
                toValueIndex.put((Object)this.valuesInOrder[i], (Object)i);
            }
            this.toValueIndex = toValueIndex.build();
        }

        @Override
        public int toIndex(T value) {
            return this.toValueIndex.getOrDefault(value, -1);
        }
    }
}

