/*
 * Decompiled with CFR 0.152.
 */
package ca.spottedleaf.starlight.mixin.common.lightengine;

import ca.spottedleaf.starlight.common.light.StarLightEngine;
import ca.spottedleaf.starlight.common.light.StarLightInterface;
import ca.spottedleaf.starlight.common.light.StarLightLightingProvider;
import ca.spottedleaf.starlight.common.util.CoordinateUtils;
import it.unimi.dsi.fastutil.longs.Long2IntOpenHashMap;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.SectionPos;
import net.minecraft.server.level.ChunkMap;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ThreadedLevelLightEngine;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkStatus;
import net.minecraft.world.level.chunk.DataLayer;
import net.minecraft.world.level.chunk.LightChunkGetter;
import net.minecraft.world.level.lighting.LevelLightEngine;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;

@Mixin(value={ThreadedLevelLightEngine.class})
public abstract class ThreadedLevelLightEngineMixin
extends LevelLightEngine
implements StarLightLightingProvider {
    @Final
    @Shadow
    private ChunkMap chunkMap;
    @Final
    @Shadow
    private static Logger LOGGER;
    @Unique
    private final Long2IntOpenHashMap chunksBeingWorkedOn = new Long2IntOpenHashMap();

    @Shadow
    public abstract void tryScheduleUpdate();

    public ThreadedLevelLightEngineMixin(LightChunkGetter chunkProvider, boolean hasBlockLight, boolean hasSkyLight) {
        super(chunkProvider, hasBlockLight, hasSkyLight);
    }

    @Unique
    private void queueTaskForSection(int chunkX, int chunkY, int chunkZ, Supplier<StarLightInterface.LightQueue.ChunkTasks> runnable) {
        ServerLevel world = (ServerLevel)this.getLightEngine().getWorld();
        ChunkAccess center = this.getLightEngine().getAnyChunkNow(chunkX, chunkZ);
        if (center == null || !center.getStatus().isOrAfter(ChunkStatus.LIGHT)) {
            return;
        }
        if (center.getStatus() != ChunkStatus.FULL) {
            runnable.get();
            return;
        }
        if (!world.getChunkSource().chunkMap.mainThreadExecutor.isSameThread()) {
            world.getChunkSource().chunkMap.mainThreadExecutor.execute(() -> this.queueTaskForSection(chunkX, chunkY, chunkZ, runnable));
            return;
        }
        long key = CoordinateUtils.getChunkKey(chunkX, chunkZ);
        StarLightInterface.LightQueue.ChunkTasks updateFuture = runnable.get();
        if (updateFuture == null) {
            return;
        }
        if (updateFuture.isTicketAdded) {
            return;
        }
        updateFuture.isTicketAdded = true;
        int references = this.chunksBeingWorkedOn.addTo(key, 1);
        if (references == 0) {
            ChunkPos pos = new ChunkPos(chunkX, chunkZ);
            world.getChunkSource().addRegionTicket(StarLightInterface.CHUNK_WORK_TICKET, pos, 0, (Object)pos);
        }
        ((CompletableFuture)updateFuture.onComplete.thenAcceptAsync(ignore -> {
            int newReferences = this.chunksBeingWorkedOn.get(key);
            if (newReferences == 1) {
                this.chunksBeingWorkedOn.remove(key);
                ChunkPos pos = new ChunkPos(chunkX, chunkZ);
                world.getChunkSource().removeRegionTicket(StarLightInterface.CHUNK_WORK_TICKET, pos, 0, (Object)pos);
            } else {
                this.chunksBeingWorkedOn.put(key, newReferences - 1);
            }
        }, (Executor)world.getChunkSource().chunkMap.mainThreadExecutor)).whenComplete((ignore, thr) -> {
            if (thr != null) {
                LOGGER.error("Failed to remove ticket level for post chunk task " + new ChunkPos(chunkX, chunkZ), thr);
            }
        });
    }

    @Overwrite
    public void checkBlock(BlockPos pos) {
        BlockPos posCopy = pos.immutable();
        this.queueTaskForSection(posCopy.getX() >> 4, posCopy.getY() >> 4, posCopy.getZ() >> 4, () -> this.getLightEngine().blockChange(posCopy));
    }

    @Overwrite
    public void updateChunkStatus(ChunkPos pos) {
    }

    @Overwrite
    public void updateSectionStatus(SectionPos pos, boolean notReady) {
        this.queueTaskForSection(pos.getX(), pos.getY(), pos.getZ(), () -> this.getLightEngine().sectionChange(pos, notReady));
    }

    @Overwrite
    public void propagateLightSources(ChunkPos pos) {
    }

    @Overwrite
    public void setLightEnabled(ChunkPos pos, boolean lightEnabled) {
    }

    @Overwrite
    public void queueSectionData(LightLayer lightType, SectionPos pos, @Nullable DataLayer nibbles) {
    }

    @Overwrite
    public void retainData(ChunkPos pos, boolean retainData) {
    }

    @Overwrite
    public CompletableFuture<ChunkAccess> initializeLight(ChunkAccess chunk, boolean lit) {
        return CompletableFuture.completedFuture(chunk);
    }

    @Overwrite
    public CompletableFuture<ChunkAccess> lightChunk(ChunkAccess chunk, boolean lit) {
        ChunkPos chunkPos = chunk.getPos();
        return CompletableFuture.supplyAsync(() -> {
            Boolean[] emptySections = StarLightEngine.getEmptySectionsForChunk(chunk);
            if (!lit) {
                chunk.setLightCorrect(false);
                this.getLightEngine().lightChunk(chunk, emptySections);
                chunk.setLightCorrect(true);
            } else {
                this.getLightEngine().forceLoadInChunk(chunk, emptySections);
                this.getLightEngine().checkChunkEdges(chunkPos.x, chunkPos.z);
            }
            this.chunkMap.releaseLightTicket(chunkPos);
            return chunk;
        }, runnable -> {
            this.getLightEngine().scheduleChunkLight(chunkPos, runnable);
            this.tryScheduleUpdate();
        }).whenComplete((c, throwable) -> {
            if (throwable != null) {
                LOGGER.error("Failed to light chunk " + chunkPos, throwable);
            }
        });
    }
}

