/*
 * Decompiled with CFR 0.152.
 */
package ca.spottedleaf.starlight.common.light;

import ca.spottedleaf.starlight.common.chunk.ExtendedChunk;
import ca.spottedleaf.starlight.common.light.BlockStarLightEngine;
import ca.spottedleaf.starlight.common.light.SWMRNibbleArray;
import ca.spottedleaf.starlight.common.light.SkyStarLightEngine;
import ca.spottedleaf.starlight.common.util.CoordinateUtils;
import ca.spottedleaf.starlight.common.util.WorldUtil;
import ca.spottedleaf.starlight.common.world.ExtendedWorld;
import it.unimi.dsi.fastutil.longs.Long2ObjectLinkedOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import it.unimi.dsi.fastutil.shorts.ShortCollection;
import it.unimi.dsi.fastutil.shorts.ShortOpenHashSet;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.function.IntConsumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.SectionPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.TicketType;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkStatus;
import net.minecraft.world.level.chunk.DataLayer;
import net.minecraft.world.level.chunk.LightChunkGetter;
import net.minecraft.world.level.lighting.LayerLightEventListener;
import net.minecraft.world.level.lighting.LevelLightEngine;

public final class StarLightInterface {
    public static final TicketType<ChunkPos> CHUNK_WORK_TICKET = TicketType.create((String)"starlight_chunk_work_ticket", (p1, p2) -> Long.compare(p1.toLong(), p2.toLong()));
    protected final Level world;
    protected final LightChunkGetter lightAccess;
    protected final ArrayDeque<SkyStarLightEngine> cachedSkyPropagators;
    protected final ArrayDeque<BlockStarLightEngine> cachedBlockPropagators;
    protected final LightQueue lightQueue = new LightQueue(this);
    protected final LayerLightEventListener skyReader;
    protected final LayerLightEventListener blockReader;
    protected final boolean isClientSide;
    protected final int minSection;
    protected final int maxSection;
    protected final int minLightSection;
    protected final int maxLightSection;
    public final LevelLightEngine lightEngine;
    private final boolean hasBlockLight;
    private final boolean hasSkyLight;

    public StarLightInterface(LightChunkGetter lightAccess, boolean hasSkyLight, boolean hasBlockLight, LevelLightEngine lightEngine) {
        this.lightAccess = lightAccess;
        this.world = lightAccess == null ? null : (Level)lightAccess.getLevel();
        this.cachedSkyPropagators = hasSkyLight && lightAccess != null ? new ArrayDeque() : null;
        this.cachedBlockPropagators = hasBlockLight && lightAccess != null ? new ArrayDeque() : null;
        boolean bl = this.isClientSide = !(this.world instanceof ServerLevel);
        if (this.world == null) {
            this.minSection = -4;
            this.maxSection = 19;
            this.minLightSection = -5;
            this.maxLightSection = 20;
        } else {
            this.minSection = WorldUtil.getMinSection((LevelHeightAccessor)this.world);
            this.maxSection = WorldUtil.getMaxSection((LevelHeightAccessor)this.world);
            this.minLightSection = WorldUtil.getMinLightSection((LevelHeightAccessor)this.world);
            this.maxLightSection = WorldUtil.getMaxLightSection((LevelHeightAccessor)this.world);
        }
        this.lightEngine = lightEngine;
        this.hasBlockLight = hasBlockLight;
        this.hasSkyLight = hasSkyLight;
        this.skyReader = !hasSkyLight ? LayerLightEventListener.DummyLightLayerEventListener.INSTANCE : new LayerLightEventListener(){

            public void checkBlock(BlockPos blockPos) {
                StarLightInterface.this.lightEngine.checkBlock(blockPos.immutable());
            }

            public void propagateLightSources(ChunkPos chunkPos) {
                throw new UnsupportedOperationException();
            }

            public boolean hasLightWork() {
                return StarLightInterface.this.hasUpdates();
            }

            public int runLightUpdates() {
                throw new UnsupportedOperationException();
            }

            public void setLightEnabled(ChunkPos chunkPos, boolean bl) {
                throw new UnsupportedOperationException();
            }

            public DataLayer getDataLayerData(SectionPos pos) {
                ChunkAccess chunk = StarLightInterface.this.getAnyChunkNow(pos.getX(), pos.getZ());
                if (chunk == null || !StarLightInterface.this.isClientSide && !chunk.isLightCorrect() || !chunk.getStatus().isOrAfter(ChunkStatus.LIGHT)) {
                    return null;
                }
                int sectionY = pos.getY();
                if (sectionY > StarLightInterface.this.maxLightSection || sectionY < StarLightInterface.this.minLightSection) {
                    return null;
                }
                if (((ExtendedChunk)chunk).getSkyEmptinessMap() == null) {
                    return null;
                }
                return ((ExtendedChunk)chunk).getSkyNibbles()[sectionY - StarLightInterface.this.minLightSection].toVanillaNibble();
            }

            public int getLightValue(BlockPos blockPos) {
                return StarLightInterface.this.getSkyLightValue(blockPos, StarLightInterface.this.getAnyChunkNow(blockPos.getX() >> 4, blockPos.getZ() >> 4));
            }

            public void updateSectionStatus(SectionPos pos, boolean notReady) {
                StarLightInterface.this.sectionChange(pos, notReady);
            }
        };
        this.blockReader = !hasBlockLight ? LayerLightEventListener.DummyLightLayerEventListener.INSTANCE : new LayerLightEventListener(){

            public void checkBlock(BlockPos blockPos) {
                StarLightInterface.this.lightEngine.checkBlock(blockPos.immutable());
            }

            public void propagateLightSources(ChunkPos chunkPos) {
                throw new UnsupportedOperationException();
            }

            public boolean hasLightWork() {
                return StarLightInterface.this.hasUpdates();
            }

            public int runLightUpdates() {
                throw new UnsupportedOperationException();
            }

            public void setLightEnabled(ChunkPos chunkPos, boolean bl) {
                throw new UnsupportedOperationException();
            }

            public DataLayer getDataLayerData(SectionPos pos) {
                ChunkAccess chunk = StarLightInterface.this.getAnyChunkNow(pos.getX(), pos.getZ());
                if (chunk == null || pos.getY() < StarLightInterface.this.minLightSection || pos.getY() > StarLightInterface.this.maxLightSection) {
                    return null;
                }
                return ((ExtendedChunk)chunk).getBlockNibbles()[pos.getY() - StarLightInterface.this.minLightSection].toVanillaNibble();
            }

            public int getLightValue(BlockPos blockPos) {
                return StarLightInterface.this.getBlockLightValue(blockPos, StarLightInterface.this.getAnyChunkNow(blockPos.getX() >> 4, blockPos.getZ() >> 4));
            }

            public void updateSectionStatus(SectionPos pos, boolean notReady) {
                StarLightInterface.this.sectionChange(pos, notReady);
            }
        };
    }

    public boolean hasSkyLight() {
        return this.hasSkyLight;
    }

    public boolean hasBlockLight() {
        return this.hasBlockLight;
    }

    public int getSkyLightValue(BlockPos blockPos, ChunkAccess chunk) {
        int currY;
        SWMRNibbleArray[] nibbles;
        SWMRNibbleArray immediate;
        if (!this.hasSkyLight) {
            return 0;
        }
        int x = blockPos.getX();
        int y = blockPos.getY();
        int z = blockPos.getZ();
        int minSection = this.minSection;
        int maxSection = this.maxSection;
        int minLightSection = this.minLightSection;
        int maxLightSection = this.maxLightSection;
        if (chunk == null || !this.isClientSide && !chunk.isLightCorrect() || !chunk.getStatus().isOrAfter(ChunkStatus.LIGHT)) {
            return 15;
        }
        int sectionY = y >> 4;
        if (sectionY > maxLightSection) {
            return 15;
        }
        if (sectionY < minLightSection) {
            sectionY = minLightSection;
            y = sectionY << 4;
        }
        if (!(immediate = (nibbles = ((ExtendedChunk)chunk).getSkyNibbles())[sectionY - minLightSection]).isNullNibbleVisible()) {
            return immediate.getVisible(x, y, z);
        }
        boolean[] emptinessMap = ((ExtendedChunk)chunk).getSkyEmptinessMap();
        if (emptinessMap == null) {
            return 15;
        }
        int lowestY = minLightSection - 1;
        for (currY = maxSection; currY >= minSection; --currY) {
            if (emptinessMap[currY - minSection]) continue;
            lowestY = currY;
            break;
        }
        if (sectionY > lowestY) {
            return 15;
        }
        for (currY = sectionY + 1; currY <= maxLightSection; ++currY) {
            SWMRNibbleArray nibble = nibbles[currY - minLightSection];
            if (nibble.isNullNibbleVisible()) continue;
            return nibble.getVisible(x, 0, z);
        }
        return 15;
    }

    public int getBlockLightValue(BlockPos blockPos, ChunkAccess chunk) {
        if (!this.hasBlockLight) {
            return 0;
        }
        int y = blockPos.getY();
        int cy = y >> 4;
        int minLightSection = this.minLightSection;
        int maxLightSection = this.maxLightSection;
        if (cy < minLightSection || cy > maxLightSection) {
            return 0;
        }
        if (chunk == null) {
            return 0;
        }
        SWMRNibbleArray nibble = ((ExtendedChunk)chunk).getBlockNibbles()[cy - minLightSection];
        return nibble.getVisible(blockPos.getX(), y, blockPos.getZ());
    }

    public int getRawBrightness(BlockPos pos, int ambientDarkness) {
        ChunkAccess chunk = this.getAnyChunkNow(pos.getX() >> 4, pos.getZ() >> 4);
        int sky = this.getSkyLightValue(pos, chunk) - ambientDarkness;
        if (sky == 15) {
            return 15;
        }
        int block = this.getBlockLightValue(pos, chunk);
        return Math.max(sky, block);
    }

    public LayerLightEventListener getSkyReader() {
        return this.skyReader;
    }

    public LayerLightEventListener getBlockReader() {
        return this.blockReader;
    }

    public boolean isClientSide() {
        return this.isClientSide;
    }

    public ChunkAccess getAnyChunkNow(int chunkX, int chunkZ) {
        if (this.world == null) {
            return null;
        }
        return ((ExtendedWorld)this.world).getAnyChunkImmediately(chunkX, chunkZ);
    }

    public boolean hasUpdates() {
        return !this.lightQueue.isEmpty();
    }

    public Level getWorld() {
        return this.world;
    }

    public LightChunkGetter getLightAccess() {
        return this.lightAccess;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final SkyStarLightEngine getSkyLightEngine() {
        SkyStarLightEngine ret;
        if (this.cachedSkyPropagators == null) {
            return null;
        }
        ArrayDeque<SkyStarLightEngine> arrayDeque = this.cachedSkyPropagators;
        synchronized (arrayDeque) {
            ret = this.cachedSkyPropagators.pollFirst();
        }
        if (ret == null) {
            return new SkyStarLightEngine(this.world);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void releaseSkyLightEngine(SkyStarLightEngine engine) {
        if (this.cachedSkyPropagators == null) {
            return;
        }
        ArrayDeque<SkyStarLightEngine> arrayDeque = this.cachedSkyPropagators;
        synchronized (arrayDeque) {
            this.cachedSkyPropagators.addFirst(engine);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final BlockStarLightEngine getBlockLightEngine() {
        BlockStarLightEngine ret;
        if (this.cachedBlockPropagators == null) {
            return null;
        }
        ArrayDeque<BlockStarLightEngine> arrayDeque = this.cachedBlockPropagators;
        synchronized (arrayDeque) {
            ret = this.cachedBlockPropagators.pollFirst();
        }
        if (ret == null) {
            return new BlockStarLightEngine(this.world);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void releaseBlockLightEngine(BlockStarLightEngine engine) {
        if (this.cachedBlockPropagators == null) {
            return;
        }
        ArrayDeque<BlockStarLightEngine> arrayDeque = this.cachedBlockPropagators;
        synchronized (arrayDeque) {
            this.cachedBlockPropagators.addFirst(engine);
        }
    }

    public LightQueue.ChunkTasks blockChange(BlockPos pos) {
        if (this.world == null || pos.getY() < WorldUtil.getMinBlockY((LevelHeightAccessor)this.world) || pos.getY() > WorldUtil.getMaxBlockY((LevelHeightAccessor)this.world)) {
            return null;
        }
        return this.lightQueue.queueBlockChange(pos);
    }

    public LightQueue.ChunkTasks sectionChange(SectionPos pos, boolean newEmptyValue) {
        if (this.world == null) {
            return null;
        }
        return this.lightQueue.queueSectionChange(pos, newEmptyValue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void forceLoadInChunk(ChunkAccess chunk, Boolean[] emptySections) {
        SkyStarLightEngine skyEngine = this.getSkyLightEngine();
        BlockStarLightEngine blockEngine = this.getBlockLightEngine();
        try {
            if (skyEngine != null) {
                skyEngine.forceHandleEmptySectionChanges(this.lightAccess, chunk, emptySections);
            }
            if (blockEngine != null) {
                blockEngine.forceHandleEmptySectionChanges(this.lightAccess, chunk, emptySections);
            }
        }
        finally {
            this.releaseSkyLightEngine(skyEngine);
            this.releaseBlockLightEngine(blockEngine);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadInChunk(int chunkX, int chunkZ, Boolean[] emptySections) {
        SkyStarLightEngine skyEngine = this.getSkyLightEngine();
        BlockStarLightEngine blockEngine = this.getBlockLightEngine();
        try {
            if (skyEngine != null) {
                skyEngine.handleEmptySectionChanges(this.lightAccess, chunkX, chunkZ, emptySections);
            }
            if (blockEngine != null) {
                blockEngine.handleEmptySectionChanges(this.lightAccess, chunkX, chunkZ, emptySections);
            }
        }
        finally {
            this.releaseSkyLightEngine(skyEngine);
            this.releaseBlockLightEngine(blockEngine);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void lightChunk(ChunkAccess chunk, Boolean[] emptySections) {
        SkyStarLightEngine skyEngine = this.getSkyLightEngine();
        BlockStarLightEngine blockEngine = this.getBlockLightEngine();
        try {
            if (skyEngine != null) {
                skyEngine.light(this.lightAccess, chunk, emptySections);
            }
            if (blockEngine != null) {
                blockEngine.light(this.lightAccess, chunk, emptySections);
            }
        }
        finally {
            this.releaseSkyLightEngine(skyEngine);
            this.releaseBlockLightEngine(blockEngine);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void relightChunks(Set<ChunkPos> chunks, Consumer<ChunkPos> chunkLightCallback, IntConsumer onComplete) {
        SkyStarLightEngine skyEngine = this.getSkyLightEngine();
        BlockStarLightEngine blockEngine = this.getBlockLightEngine();
        try {
            if (skyEngine != null) {
                skyEngine.relightChunks(this.lightAccess, chunks, blockEngine == null ? chunkLightCallback : null, blockEngine == null ? onComplete : null);
            }
            if (blockEngine != null) {
                blockEngine.relightChunks(this.lightAccess, chunks, chunkLightCallback, onComplete);
            }
        }
        finally {
            this.releaseSkyLightEngine(skyEngine);
            this.releaseBlockLightEngine(blockEngine);
        }
    }

    public void checkChunkEdges(int chunkX, int chunkZ) {
        this.checkSkyEdges(chunkX, chunkZ);
        this.checkBlockEdges(chunkX, chunkZ);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkSkyEdges(int chunkX, int chunkZ) {
        SkyStarLightEngine skyEngine = this.getSkyLightEngine();
        try {
            if (skyEngine != null) {
                skyEngine.checkChunkEdges(this.lightAccess, chunkX, chunkZ);
            }
        }
        finally {
            this.releaseSkyLightEngine(skyEngine);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkBlockEdges(int chunkX, int chunkZ) {
        BlockStarLightEngine blockEngine = this.getBlockLightEngine();
        try {
            if (blockEngine != null) {
                blockEngine.checkChunkEdges(this.lightAccess, chunkX, chunkZ);
            }
        }
        finally {
            this.releaseBlockLightEngine(blockEngine);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkSkyEdges(int chunkX, int chunkZ, ShortCollection sections) {
        SkyStarLightEngine skyEngine = this.getSkyLightEngine();
        try {
            if (skyEngine != null) {
                skyEngine.checkChunkEdges(this.lightAccess, chunkX, chunkZ, sections);
            }
        }
        finally {
            this.releaseSkyLightEngine(skyEngine);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkBlockEdges(int chunkX, int chunkZ, ShortCollection sections) {
        BlockStarLightEngine blockEngine = this.getBlockLightEngine();
        try {
            if (blockEngine != null) {
                blockEngine.checkChunkEdges(this.lightAccess, chunkX, chunkZ, sections);
            }
        }
        finally {
            this.releaseBlockLightEngine(blockEngine);
        }
    }

    public void scheduleChunkLight(ChunkPos pos, Runnable run) {
        this.lightQueue.queueChunkLighting(pos, run);
    }

    public void removeChunkTasks(ChunkPos pos) {
        this.lightQueue.removeChunk(pos);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void propagateChanges() {
        if (this.lightQueue.isEmpty()) {
            return;
        }
        SkyStarLightEngine skyEngine = this.getSkyLightEngine();
        BlockStarLightEngine blockEngine = this.getBlockLightEngine();
        try {
            LightQueue.ChunkTasks task;
            while ((task = this.lightQueue.removeFirstTask()) != null) {
                if (task.lightTasks != null) {
                    for (Runnable run : task.lightTasks) {
                        run.run();
                    }
                }
                long coordinate = task.chunkCoordinate;
                int chunkX = CoordinateUtils.getChunkX(coordinate);
                int chunkZ = CoordinateUtils.getChunkZ(coordinate);
                Set<BlockPos> positions = task.changedPositions;
                Boolean[] sectionChanges = task.changedSectionSet;
                if (!(skyEngine == null || positions.isEmpty() && sectionChanges == null)) {
                    skyEngine.blocksChangedInChunk(this.lightAccess, chunkX, chunkZ, positions, sectionChanges);
                }
                if (!(blockEngine == null || positions.isEmpty() && sectionChanges == null)) {
                    blockEngine.blocksChangedInChunk(this.lightAccess, chunkX, chunkZ, positions, sectionChanges);
                }
                if (skyEngine != null && task.queuedEdgeChecksSky != null) {
                    skyEngine.checkChunkEdges(this.lightAccess, chunkX, chunkZ, (ShortCollection)task.queuedEdgeChecksSky);
                }
                if (blockEngine != null && task.queuedEdgeChecksBlock != null) {
                    blockEngine.checkChunkEdges(this.lightAccess, chunkX, chunkZ, (ShortCollection)task.queuedEdgeChecksBlock);
                }
                task.onComplete.complete(null);
            }
        }
        finally {
            this.releaseSkyLightEngine(skyEngine);
            this.releaseBlockLightEngine(blockEngine);
        }
    }

    public static final class LightQueue {
        protected final Long2ObjectLinkedOpenHashMap<ChunkTasks> chunkTasks = new Long2ObjectLinkedOpenHashMap();
        protected final StarLightInterface manager;

        public LightQueue(StarLightInterface manager) {
            this.manager = manager;
        }

        public synchronized boolean isEmpty() {
            return this.chunkTasks.isEmpty();
        }

        public synchronized ChunkTasks queueBlockChange(BlockPos pos) {
            ChunkTasks tasks = (ChunkTasks)this.chunkTasks.computeIfAbsent(CoordinateUtils.getChunkKey(pos), ChunkTasks::new);
            tasks.changedPositions.add(pos.immutable());
            return tasks;
        }

        public synchronized ChunkTasks queueSectionChange(SectionPos pos, boolean newEmptyValue) {
            ChunkTasks tasks = (ChunkTasks)this.chunkTasks.computeIfAbsent(CoordinateUtils.getChunkKey(pos), ChunkTasks::new);
            if (tasks.changedSectionSet == null) {
                tasks.changedSectionSet = new Boolean[this.manager.maxSection - this.manager.minSection + 1];
            }
            tasks.changedSectionSet[pos.getY() - this.manager.minSection] = newEmptyValue;
            return tasks;
        }

        public synchronized ChunkTasks queueChunkLighting(ChunkPos pos, Runnable lightTask) {
            ChunkTasks tasks = (ChunkTasks)this.chunkTasks.computeIfAbsent(CoordinateUtils.getChunkKey(pos), ChunkTasks::new);
            if (tasks.lightTasks == null) {
                tasks.lightTasks = new ArrayList<Runnable>();
            }
            tasks.lightTasks.add(lightTask);
            return tasks;
        }

        public synchronized ChunkTasks queueChunkSkylightEdgeCheck(SectionPos pos, ShortCollection sections) {
            ChunkTasks tasks = (ChunkTasks)this.chunkTasks.computeIfAbsent(CoordinateUtils.getChunkKey(pos), ChunkTasks::new);
            ShortOpenHashSet queuedEdges = tasks.queuedEdgeChecksSky;
            if (queuedEdges == null) {
                queuedEdges = tasks.queuedEdgeChecksSky = new ShortOpenHashSet();
            }
            queuedEdges.addAll(sections);
            return tasks;
        }

        public synchronized ChunkTasks queueChunkBlocklightEdgeCheck(SectionPos pos, ShortCollection sections) {
            ChunkTasks tasks = (ChunkTasks)this.chunkTasks.computeIfAbsent(CoordinateUtils.getChunkKey(pos), ChunkTasks::new);
            ShortOpenHashSet queuedEdges = tasks.queuedEdgeChecksBlock;
            if (queuedEdges == null) {
                queuedEdges = tasks.queuedEdgeChecksBlock = new ShortOpenHashSet();
            }
            queuedEdges.addAll(sections);
            return tasks;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removeChunk(ChunkPos pos) {
            ChunkTasks tasks;
            LightQueue lightQueue = this;
            synchronized (lightQueue) {
                tasks = (ChunkTasks)this.chunkTasks.remove(CoordinateUtils.getChunkKey(pos));
            }
            if (tasks != null) {
                tasks.onComplete.complete(null);
            }
        }

        public synchronized ChunkTasks removeFirstTask() {
            if (this.chunkTasks.isEmpty()) {
                return null;
            }
            return (ChunkTasks)this.chunkTasks.removeFirst();
        }

        public static final class ChunkTasks {
            public final Set<BlockPos> changedPositions = new ObjectOpenHashSet();
            public Boolean[] changedSectionSet;
            public ShortOpenHashSet queuedEdgeChecksSky;
            public ShortOpenHashSet queuedEdgeChecksBlock;
            public List<Runnable> lightTasks;
            public boolean isTicketAdded = false;
            public final CompletableFuture<Void> onComplete = new CompletableFuture();
            public final long chunkCoordinate;

            public ChunkTasks(long chunkCoordinate) {
                this.chunkCoordinate = chunkCoordinate;
            }
        }
    }
}

