/*
 * Decompiled with CFR 0.152.
 */
package net.raphimc.immediatelyfast.injection.mixins.fast_text_lookup;

import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.font.FontManager;
import net.minecraft.client.gui.font.FontSet;
import net.minecraft.resources.ResourceLocation;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={FontManager.class}, priority=500)
public abstract class MixinFontManager {
    @Shadow
    @Final
    private Map<ResourceLocation, FontSet> fontSets;
    @Shadow
    private Map<ResourceLocation, ResourceLocation> renames;
    @Unique
    private final Map<ResourceLocation, FontSet> immediatelyFast$overriddenFontStorages = new Object2ObjectOpenHashMap();
    @Unique
    private FontSet immediatelyFast$defaultFontStorage;
    @Unique
    private FontSet immediatelyFast$unicodeFontStorage;

    @Shadow
    protected abstract FontSet lambda$createFont$17(ResourceLocation var1);

    @Inject(method={"apply(Lnet/minecraft/client/gui/font/FontManager$Preparation;Lnet/minecraft/util/profiling/ProfilerFiller;)V"}, at={@At(value="RETURN")})
    private void rebuildOverriddenFontStoragesOnReload(CallbackInfo ci) {
        this.immediatelyFast$rebuildOverriddenFontStorages();
    }

    @Inject(method={"setRenames(Ljava/util/Map;)V"}, at={@At(value="RETURN")})
    private void rebuildOverriddenFontStoragesOnChange(CallbackInfo ci) {
        this.immediatelyFast$rebuildOverriddenFontStorages();
    }

    @ModifyArg(method={"createFont()Lnet/minecraft/client/gui/Font;", "createFontFilterFishy()Lnet/minecraft/client/gui/Font;"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/gui/Font;<init>(Ljava/util/function/Function;Z)V"))
    private Function<ResourceLocation, FontSet> overrideFontStorage(Function<ResourceLocation, FontSet> original) {
        return id -> {
            if (Minecraft.DEFAULT_FONT.equals(id) && this.immediatelyFast$defaultFontStorage != null) {
                return this.immediatelyFast$defaultFontStorage;
            }
            if (Minecraft.UNIFORM_FONT.equals(id) && this.immediatelyFast$unicodeFontStorage != null) {
                return this.immediatelyFast$unicodeFontStorage;
            }
            FontSet storage = this.immediatelyFast$overriddenFontStorages.get(id);
            if (storage != null) {
                return storage;
            }
            return (FontSet)original.apply((ResourceLocation)id);
        };
    }

    @Unique
    private void immediatelyFast$rebuildOverriddenFontStorages() {
        this.immediatelyFast$overriddenFontStorages.clear();
        this.immediatelyFast$overriddenFontStorages.putAll(this.fontSets);
        for (ResourceLocation key : this.renames.keySet()) {
            this.immediatelyFast$overriddenFontStorages.put(key, this.lambda$createFont$17(key));
        }
        this.immediatelyFast$defaultFontStorage = this.immediatelyFast$overriddenFontStorages.get(Minecraft.DEFAULT_FONT);
        this.immediatelyFast$unicodeFontStorage = this.immediatelyFast$overriddenFontStorages.get(Minecraft.UNIFORM_FONT);
    }
}

