/*
 * Decompiled with CFR 0.152.
 */
package net.raphimc.immediatelyfast.feature.core;

import com.google.common.collect.ImmutableMap;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.VertexConsumer;
import it.unimi.dsi.fastutil.objects.Reference2ObjectLinkedOpenHashMap;
import it.unimi.dsi.fastutil.objects.Reference2ObjectMap;
import it.unimi.dsi.fastutil.objects.ReferenceLinkedOpenHashSet;
import it.unimi.dsi.fastutil.objects.ReferenceSet;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.raphimc.immediatelyfast.ImmediatelyFast;
import net.raphimc.immediatelyfast.compat.IrisCompat;
import net.raphimc.immediatelyfast.feature.core.BufferBuilderPool;

public abstract class ImmediateAdapter
extends MultiBufferSource.BufferSource
implements AutoCloseable {
    private static final BufferBuilder FALLBACK_BUFFER = new BufferBuilder(0);
    protected final Reference2ObjectMap<RenderType, ReferenceSet<BufferBuilder>> fallbackBuffers = new Reference2ObjectLinkedOpenHashMap();
    protected final ReferenceSet<RenderType> activeLayers = new ReferenceLinkedOpenHashSet();
    protected boolean drawFallbackLayersFirst = false;

    public ImmediateAdapter() {
        this((Map<RenderType, BufferBuilder>)ImmutableMap.of());
    }

    public ImmediateAdapter(Map<RenderType, BufferBuilder> layerBuffers) {
        this(FALLBACK_BUFFER, layerBuffers);
    }

    public ImmediateAdapter(BufferBuilder fallbackBuffer, Map<RenderType, BufferBuilder> layerBuffers) {
        super(fallbackBuffer, layerBuffers);
    }

    public VertexConsumer getBuffer(RenderType layer) {
        Optional newLayer = layer.asOptional();
        if (!this.drawFallbackLayersFirst && !this.lastState.equals(newLayer) && this.lastState.isPresent() && !this.fixedBuffers.containsKey(this.lastState.get())) {
            this.drawFallbackLayersFirst = true;
        }
        this.lastState = newLayer;
        BufferBuilder bufferBuilder = this.getOrCreateBufferBuilder(layer);
        if (bufferBuilder.building() && !layer.canConsolidateConsecutiveGeometry()) {
            throw new IllegalStateException("Tried to write shared vertices into the same buffer");
        }
        if (!bufferBuilder.building()) {
            if (IrisCompat.IRIS_LOADED && !IrisCompat.isRenderingLevel.getAsBoolean()) {
                IrisCompat.iris$beginWithoutExtending.accept(bufferBuilder, layer.mode(), layer.format());
            } else {
                bufferBuilder.begin(layer.mode(), layer.format());
            }
            this.activeLayers.add((Object)layer);
        } else if ((ImmediatelyFast.config.debug_only_use_last_usage_for_batch_ordering || layer.name.contains("immediatelyfast:renderlast")) && this.activeLayers.contains((Object)layer)) {
            this.activeLayers.remove((Object)layer);
            this.activeLayers.add((Object)layer);
        }
        return bufferBuilder;
    }

    public void endLastBatch() {
        this.lastState = Optional.empty();
        this.drawFallbackLayersFirst = false;
        int sortedLayersLength = 0;
        RenderType[] sortedLayers = new RenderType[this.activeLayers.size()];
        for (RenderType layer : this.activeLayers) {
            if (this.fixedBuffers.containsKey(layer)) continue;
            sortedLayers[sortedLayersLength++] = layer;
        }
        if (sortedLayersLength == 0) {
            return;
        }
        Arrays.sort(sortedLayers, (l1, l2) -> {
            if (l1 == null || l2 == null) {
                return 0;
            }
            if (l1.sortOnUpload == l2.sortOnUpload) {
                return 0;
            }
            return l1.sortOnUpload ? 1 : -1;
        });
        for (int i = 0; i < sortedLayersLength; ++i) {
            this.endBatch(sortedLayers[i]);
        }
    }

    public void endBatch() {
        if (this.activeLayers.isEmpty()) {
            this.close();
            return;
        }
        this.endLastBatch();
        for (RenderType layer : this.fixedBuffers.keySet()) {
            this.endBatch(layer);
        }
    }

    public void endBatch(RenderType layer) {
        if (this.drawFallbackLayersFirst) {
            this.endLastBatch();
        }
        if (IrisCompat.IRIS_LOADED && !IrisCompat.isRenderingLevel.getAsBoolean()) {
            IrisCompat.renderWithExtendedVertexFormat.accept(false);
        }
        this.activeLayers.remove((Object)layer);
        this._draw(layer);
        this.fallbackBuffers.remove((Object)layer);
        if (IrisCompat.IRIS_LOADED && !IrisCompat.isRenderingLevel.getAsBoolean()) {
            IrisCompat.renderWithExtendedVertexFormat.accept(true);
        }
    }

    @Override
    public void close() {
        this.lastState = Optional.empty();
        this.drawFallbackLayersFirst = false;
        for (RenderType layer : this.activeLayers) {
            for (BufferBuilder bufferBuilder : this.getBufferBuilder(layer)) {
                bufferBuilder.end().release();
            }
        }
        this.activeLayers.clear();
        this.fallbackBuffers.clear();
    }

    public boolean hasActiveLayers() {
        return !this.activeLayers.isEmpty();
    }

    protected abstract void _draw(RenderType var1);

    protected BufferBuilder getOrCreateBufferBuilder(RenderType layer) {
        if (!layer.canConsolidateConsecutiveGeometry()) {
            return this.addNewFallbackBuffer(layer);
        }
        if (this.fixedBuffers.containsKey(layer)) {
            return (BufferBuilder)this.fixedBuffers.get(layer);
        }
        if (this.fallbackBuffers.containsKey((Object)layer)) {
            return (BufferBuilder)((ReferenceSet)this.fallbackBuffers.get((Object)layer)).iterator().next();
        }
        return this.addNewFallbackBuffer(layer);
    }

    protected Set<BufferBuilder> getBufferBuilder(RenderType layer) {
        if (this.fallbackBuffers.containsKey((Object)layer)) {
            return (Set)this.fallbackBuffers.get((Object)layer);
        }
        if (this.fixedBuffers.containsKey(layer)) {
            return Collections.singleton((BufferBuilder)this.fixedBuffers.get(layer));
        }
        return Collections.emptySet();
    }

    protected BufferBuilder addNewFallbackBuffer(RenderType layer) {
        BufferBuilder bufferBuilder = BufferBuilderPool.get();
        ((ReferenceSet)this.fallbackBuffers.computeIfAbsent((Object)layer, k -> new ReferenceLinkedOpenHashSet())).add((Object)bufferBuilder);
        return bufferBuilder;
    }
}

