/*
 * Decompiled with CFR 0.152.
 */
package net.raphimc.immediatelyfast.feature.batching;

import com.mojang.blaze3d.vertex.BufferBuilder;
import it.unimi.dsi.fastutil.objects.Object2ObjectLinkedOpenHashMap;
import java.util.Map;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.raphimc.immediatelyfast.ImmediatelyFast;
import net.raphimc.immediatelyfast.feature.batching.GuiOverlayFirstBatchableImmediate;
import net.raphimc.immediatelyfast.feature.batching.ItemModelBatchableImmediate;
import net.raphimc.immediatelyfast.feature.batching.RenderSystemState;
import net.raphimc.immediatelyfast.feature.core.BatchableImmediate;

public class BatchingBuffers {
    public static MultiBufferSource FILL_CONSUMER = null;
    public static MultiBufferSource TEXTURE_CONSUMER = null;
    public static MultiBufferSource TEXT_CONSUMER = null;
    public static MultiBufferSource LIT_ITEM_MODEL_CONSUMER = null;
    public static MultiBufferSource UNLIT_ITEM_MODEL_CONSUMER = null;
    public static MultiBufferSource ITEM_OVERLAY_CONSUMER = null;
    private static final BatchableImmediate HUD_BATCH = new BatchableImmediate();
    private static final BatchableImmediate DEBUG_HUD_BATCH = new GuiOverlayFirstBatchableImmediate();
    private static final BatchableImmediate LIT_ITEM_MODEL_BATCH = new ItemModelBatchableImmediate(true);
    private static final BatchableImmediate UNLIT_ITEM_MODEL_BATCH = new ItemModelBatchableImmediate(false);
    private static final BatchableImmediate ITEM_OVERLAY_BATCH = new BatchableImmediate();
    private static MultiBufferSource PREV_FILL_CONSUMER = null;
    private static MultiBufferSource PREV_TEXT_CONSUMER = null;
    private static MultiBufferSource PREV_TEXTURE_CONSUMER = null;

    public static void beginHudBatching() {
        BatchingBuffers.beginHudBatching(HUD_BATCH);
    }

    public static void beginDebugHudBatching() {
        BatchingBuffers.beginHudBatching(DEBUG_HUD_BATCH);
    }

    public static void beginHudBatching(BatchableImmediate batch) {
        if (batch.hasActiveLayers()) {
            ImmediatelyFast.LOGGER.warn("HUD batching was already active! endHudBatching() was not called before beginHudBatching(). This will cause rendering issues.");
            batch.close();
        }
        FILL_CONSUMER = batch;
        TEXTURE_CONSUMER = batch;
        TEXT_CONSUMER = batch;
        BatchingBuffers.beginItemModelBatching();
        BatchingBuffers.beginItemOverlayBatching();
    }

    public static void endHudBatching() {
        BatchingBuffers.endHudBatching(HUD_BATCH);
    }

    public static void endDebugHudBatching() {
        BatchingBuffers.endHudBatching(DEBUG_HUD_BATCH);
    }

    public static void endHudBatching(BatchableImmediate batch) {
        FILL_CONSUMER = null;
        TEXTURE_CONSUMER = null;
        TEXT_CONSUMER = null;
        RenderSystemState renderSystemState = RenderSystemState.current();
        batch.endBatch();
        BatchingBuffers.endItemModelBatching();
        BatchingBuffers.endItemOverlayBatching();
        renderSystemState.apply();
    }

    public static boolean isHudBatching() {
        return TEXT_CONSUMER != null || TEXTURE_CONSUMER != null || FILL_CONSUMER != null || LIT_ITEM_MODEL_CONSUMER != null || UNLIT_ITEM_MODEL_CONSUMER != null || ITEM_OVERLAY_CONSUMER != null;
    }

    private static void beginItemModelBatching() {
        if (LIT_ITEM_MODEL_BATCH.hasActiveLayers() || UNLIT_ITEM_MODEL_BATCH.hasActiveLayers()) {
            ImmediatelyFast.LOGGER.warn("Item model batching was already active! endItemModelBatching() was not called before beginItemModelBatching(). This will cause rendering issues.");
            LIT_ITEM_MODEL_BATCH.close();
            UNLIT_ITEM_MODEL_BATCH.close();
        }
        LIT_ITEM_MODEL_CONSUMER = LIT_ITEM_MODEL_BATCH;
        UNLIT_ITEM_MODEL_CONSUMER = UNLIT_ITEM_MODEL_BATCH;
    }

    private static void endItemModelBatching() {
        LIT_ITEM_MODEL_CONSUMER = null;
        UNLIT_ITEM_MODEL_CONSUMER = null;
        UNLIT_ITEM_MODEL_BATCH.endBatch();
        LIT_ITEM_MODEL_BATCH.endBatch();
    }

    private static void beginItemOverlayBatching() {
        if (ITEM_OVERLAY_BATCH.hasActiveLayers()) {
            ImmediatelyFast.LOGGER.warn("Item overlay batching was already active! endItemOverlayBatching() was not called before beginItemOverlayBatching(). This will cause rendering issues.");
            ITEM_OVERLAY_BATCH.close();
        }
        ITEM_OVERLAY_CONSUMER = ITEM_OVERLAY_BATCH;
    }

    private static void endItemOverlayBatching() {
        ITEM_OVERLAY_CONSUMER = null;
        ITEM_OVERLAY_BATCH.endBatch();
    }

    public static void beginItemOverlayRendering() {
        if (ITEM_OVERLAY_CONSUMER != null) {
            PREV_FILL_CONSUMER = FILL_CONSUMER;
            PREV_TEXT_CONSUMER = TEXT_CONSUMER;
            PREV_TEXTURE_CONSUMER = TEXTURE_CONSUMER;
            FILL_CONSUMER = ITEM_OVERLAY_CONSUMER;
            TEXT_CONSUMER = ITEM_OVERLAY_CONSUMER;
            TEXTURE_CONSUMER = ITEM_OVERLAY_CONSUMER;
        }
    }

    public static void endItemOverlayRendering() {
        if (ITEM_OVERLAY_CONSUMER != null) {
            FILL_CONSUMER = PREV_FILL_CONSUMER;
            TEXT_CONSUMER = PREV_TEXT_CONSUMER;
            TEXTURE_CONSUMER = PREV_TEXTURE_CONSUMER;
        }
    }

    public static Map<RenderType, BufferBuilder> createLayerBuffers(RenderType ... layers) {
        Object2ObjectLinkedOpenHashMap layerBuffers = new Object2ObjectLinkedOpenHashMap(layers.length);
        for (RenderType layer : layers) {
            layerBuffers.put((Object)layer, (Object)new BufferBuilder(layer.bufferSize()));
        }
        return layerBuffers;
    }
}

