/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.clothconfig2.gui;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Supplier;
import me.shedaniel.clothconfig2.ClothConfigInitializer;
import me.shedaniel.clothconfig2.api.AbstractConfigEntry;
import me.shedaniel.clothconfig2.api.AbstractConfigListEntry;
import me.shedaniel.clothconfig2.api.ConfigCategory;
import me.shedaniel.clothconfig2.api.Expandable;
import me.shedaniel.clothconfig2.api.LazyResettable;
import me.shedaniel.clothconfig2.api.ReferenceBuildingConfigScreen;
import me.shedaniel.clothconfig2.api.ReferenceProvider;
import me.shedaniel.clothconfig2.api.ScissorsHandler;
import me.shedaniel.clothconfig2.api.scroll.ScrollingContainer;
import me.shedaniel.clothconfig2.gui.AbstractConfigScreen;
import me.shedaniel.clothconfig2.gui.ClothConfigScreen;
import me.shedaniel.clothconfig2.gui.entries.EmptyEntry;
import me.shedaniel.clothconfig2.gui.widget.SearchFieldEntry;
import me.shedaniel.math.Rectangle;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ComponentPath;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.navigation.FocusNavigationEvent;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Mth;
import net.minecraft.util.Tuple;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;

public class GlobalizedClothConfigScreen
extends AbstractConfigScreen
implements ReferenceBuildingConfigScreen,
Expandable {
    public ClothConfigScreen.ListWidget<AbstractConfigEntry<AbstractConfigEntry<?>>> listWidget;
    private AbstractWidget cancelButton;
    private AbstractWidget exitButton;
    private final LinkedHashMap<Component, List<AbstractConfigEntry<?>>> categorizedEntries = Maps.newLinkedHashMap();
    private final ScrollingContainer sideScroller = new ScrollingContainer(){

        @Override
        public Rectangle getBounds() {
            return new Rectangle(4, 4, GlobalizedClothConfigScreen.this.getSideSliderPosition() - 14 - 4, GlobalizedClothConfigScreen.this.height - 8);
        }

        @Override
        public int getMaxScrollHeight() {
            int i = 0;
            for (Reference reference : GlobalizedClothConfigScreen.this.references) {
                if (i != 0) {
                    i = (int)((float)i + 3.0f * reference.getScale());
                }
                float f = i;
                Objects.requireNonNull(GlobalizedClothConfigScreen.this.font);
                i = (int)(f + 9.0f * reference.getScale());
            }
            return i;
        }
    };
    private Reference lastHoveredReference = null;
    private SearchFieldEntry searchFieldEntry;
    private final ScrollingContainer sideSlider = new ScrollingContainer(){
        private final Rectangle empty = new Rectangle();

        @Override
        public Rectangle getBounds() {
            return this.empty;
        }

        @Override
        public int getMaxScrollHeight() {
            return 1;
        }
    };
    private final List<Reference> references = Lists.newArrayList();
    private final LazyResettable<Integer> sideExpandLimit = new LazyResettable<Integer>(() -> {
        int max = 0;
        for (Reference reference : this.references) {
            Component referenceText = reference.getText();
            int width = this.font.width((FormattedText)Component.literal((String)(StringUtils.repeat((String)"  ", (int)reference.getIndent()) + "- ")).append(referenceText));
            if (width <= max) continue;
            max = width;
        }
        return Math.min(max + 8, this.width / 4);
    });
    private boolean requestingReferenceRebuilding = false;

    @ApiStatus.Internal
    public GlobalizedClothConfigScreen(Screen parent, Component title, Map<String, ConfigCategory> categoryMap, ResourceLocation backgroundLocation) {
        super(parent, title, backgroundLocation);
        categoryMap.forEach((categoryName, category) -> {
            ArrayList entries = Lists.newArrayList();
            for (Object object : category.getEntries()) {
                AbstractConfigListEntry entry = object instanceof Tuple ? (AbstractConfigListEntry)((Tuple)object).getB() : (AbstractConfigListEntry)object;
                entry.setScreen(this);
                entries.add(entry);
            }
            this.categorizedEntries.put(category.getCategoryKey(), entries);
        });
        this.sideSlider.scrollTo(0.0, false);
    }

    @Override
    public void requestReferenceRebuilding() {
        this.requestingReferenceRebuilding = true;
    }

    @Override
    public Map<Component, List<AbstractConfigEntry<?>>> getCategorizedEntries() {
        return this.categorizedEntries;
    }

    protected void init() {
        super.init();
        this.sideExpandLimit.reset();
        this.references.clear();
        this.buildReferences();
        this.listWidget = new ClothConfigScreen.ListWidget(this, this.minecraft, this.width - 14, this.height, 30, this.height - 32, this.getBackgroundLocation());
        this.addWidget((GuiEventListener)this.listWidget);
        this.listWidget.setLeftPos(14);
        this.listWidget.children().add(new EmptyEntry(5));
        this.searchFieldEntry = new SearchFieldEntry(this, this.listWidget);
        this.listWidget.children().add(this.searchFieldEntry);
        this.listWidget.children().add(new EmptyEntry(5));
        this.categorizedEntries.forEach((category, entries) -> {
            if (!this.listWidget.children().isEmpty()) {
                this.listWidget.children().add(new EmptyEntry(5));
            }
            this.listWidget.children().add(new EmptyEntry(4));
            this.listWidget.children().add(new CategoryTextEntry((Component)category, (Component)category.copy().withStyle(ChatFormatting.BOLD)));
            this.listWidget.children().add(new EmptyEntry(4));
            this.listWidget.children().addAll((Collection<AbstractConfigEntry<AbstractConfigEntry<?>>>)entries);
        });
        int buttonWidths = Math.min(200, (this.width - 50 - 12) / 3);
        this.cancelButton = Button.builder((Component)(this.isEdited() ? Component.translatable((String)"text.cloth-config.cancel_discard") : Component.translatable((String)"gui.cancel")), widget -> this.quit()).bounds(0, this.height - 26, buttonWidths, 20).build();
        this.addRenderableWidget((GuiEventListener)this.cancelButton);
        this.exitButton = new Button(0, this.height - 26, buttonWidths, 20, (Component)Component.empty(), button -> this.saveAll(true), Supplier::get){

            public void renderWidget(GuiGraphics graphics, int mouseX, int mouseY, float delta) {
                boolean hasErrors = false;
                block0: for (List<AbstractConfigEntry<?>> entries : GlobalizedClothConfigScreen.this.categorizedEntries.values()) {
                    for (AbstractConfigEntry<?> entry : entries) {
                        if (!entry.getConfigError().isPresent()) continue;
                        hasErrors = true;
                        break block0;
                    }
                }
                this.active = GlobalizedClothConfigScreen.this.isEdited() && !hasErrors;
                this.setMessage((Component)(hasErrors ? Component.translatable((String)"text.cloth-config.error_cannot_save") : Component.translatable((String)"text.cloth-config.save_and_done")));
                super.renderWidget(graphics, mouseX, mouseY, delta);
            }
        };
        this.addRenderableWidget((GuiEventListener)this.exitButton);
        Optional.ofNullable(this.afterInitConsumer).ifPresent(consumer -> consumer.accept(this));
    }

    @Override
    public boolean matchesSearch(Iterator<String> tags) {
        return this.searchFieldEntry.matchesSearch(tags);
    }

    private void buildReferences() {
        this.categorizedEntries.forEach((categoryText, entries) -> {
            this.references.add(new CategoryReference((Component)categoryText));
            for (AbstractConfigEntry entry : entries) {
                this.buildReferenceFor(entry, 1);
            }
        });
    }

    private void buildReferenceFor(AbstractConfigEntry<?> entry, int layer) {
        List<ReferenceProvider<?>> referencableEntries = entry.getReferenceProviderEntries();
        if (referencableEntries != null) {
            this.references.add(new ConfigEntryReference(entry, layer));
            for (ReferenceProvider<?> referencableEntry : referencableEntries) {
                this.buildReferenceFor(referencableEntry.provideReferenceEntry(), layer + 1);
            }
        }
    }

    @Override
    public void render(GuiGraphics graphics, int mouseX, int mouseY, float delta) {
        this.lastHoveredReference = null;
        if (this.requestingReferenceRebuilding) {
            this.references.clear();
            this.buildReferences();
            this.requestingReferenceRebuilding = false;
        }
        int sliderPosition = this.getSideSliderPosition();
        ScissorsHandler.INSTANCE.scissor(new Rectangle(sliderPosition, 0, this.width - sliderPosition, this.height));
        if (this.isTransparentBackground()) {
            graphics.fillGradient(14, 0, this.width, this.height, -1072689136, -804253680);
        } else {
            this.renderDirtBackground(graphics);
            this.overlayBackground(graphics, new Rectangle(14, 0, this.width, this.height), 64, 64, 64, 255, 255);
        }
        this.listWidget.width = this.width - sliderPosition;
        this.listWidget.setLeftPos(sliderPosition);
        this.listWidget.render(graphics, mouseX, mouseY, delta);
        ScissorsHandler.INSTANCE.scissor(new Rectangle(this.listWidget.left, this.listWidget.top, this.listWidget.width, this.listWidget.bottom - this.listWidget.top));
        for (AbstractConfigEntry<AbstractConfigEntry<?>> child : this.listWidget.children()) {
            child.lateRender(graphics, mouseX, mouseY, delta);
        }
        ScissorsHandler.INSTANCE.removeLastScissor();
        graphics.drawString(this.font, this.title.getVisualOrderText(), (int)((float)sliderPosition + (float)(this.width - sliderPosition) / 2.0f - (float)this.font.width((FormattedText)this.title) / 2.0f), 12, -1);
        ScissorsHandler.INSTANCE.removeLastScissor();
        this.cancelButton.setX(sliderPosition + (this.width - sliderPosition) / 2 - this.cancelButton.getWidth() - 3);
        this.exitButton.setX(sliderPosition + (this.width - sliderPosition) / 2 + 3);
        super.render(graphics, mouseX, mouseY, delta);
        this.sideSlider.updatePosition(delta);
        this.sideScroller.updatePosition(delta);
        if (this.isTransparentBackground()) {
            graphics.fillGradient(0, 0, sliderPosition, this.height, -1240461296, -972025840);
            graphics.fillGradient(0, 0, sliderPosition - 14, this.height, 0x68000000, 0x68000000);
        } else {
            Tesselator tesselator = Tesselator.getInstance();
            BufferBuilder buffer = tesselator.getBuilder();
            RenderSystem.setShader(GameRenderer::getPositionTexColorShader);
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)this.getBackgroundLocation());
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            float f = 32.0f;
            buffer.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX_COLOR);
            buffer.vertex((double)(sliderPosition - 14), (double)this.height, 0.0).uv(0.0f, (float)this.height / 32.0f).color(68, 68, 68, 255).endVertex();
            buffer.vertex((double)sliderPosition, (double)this.height, 0.0).uv(0.4375f, (float)this.height / 32.0f).color(68, 68, 68, 255).endVertex();
            buffer.vertex((double)sliderPosition, 0.0, 0.0).uv(0.4375f, 0.0f).color(68, 68, 68, 255).endVertex();
            buffer.vertex((double)(sliderPosition - 14), 0.0, 0.0).uv(0.0f, 0.0f).color(68, 68, 68, 255).endVertex();
            buffer.vertex(0.0, (double)this.height, 0.0).uv(0.0f, (float)(this.height + this.sideScroller.scrollAmountInt()) / 32.0f).color(32, 32, 32, 255).endVertex();
            buffer.vertex((double)(sliderPosition - 14), (double)this.height, 0.0).uv((float)(sliderPosition - 14) / 32.0f, (float)(this.height + this.sideScroller.scrollAmountInt()) / 32.0f).color(32, 32, 32, 255).endVertex();
            buffer.vertex((double)(sliderPosition - 14), 0.0, 0.0).uv((float)(sliderPosition - 14) / 32.0f, (float)this.sideScroller.scrollAmountInt() / 32.0f).color(32, 32, 32, 255).endVertex();
            buffer.vertex(0.0, 0.0, 0.0).uv(0.0f, (float)this.sideScroller.scrollAmountInt() / 32.0f).color(32, 32, 32, 255).endVertex();
            tesselator.end();
        }
        Matrix4f matrix = graphics.pose().last().pose();
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShader(GameRenderer::getPositionColorShader);
        Tesselator tesselator = Tesselator.getInstance();
        BufferBuilder buffer = tesselator.getBuilder();
        int shadeColor = this.isTransparentBackground() ? 120 : 160;
        buffer.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_COLOR);
        buffer.vertex(matrix, (float)(sliderPosition + 4), 0.0f, 100.0f).color(0, 0, 0, 0).endVertex();
        buffer.vertex(matrix, (float)sliderPosition, 0.0f, 100.0f).color(0, 0, 0, shadeColor).endVertex();
        buffer.vertex(matrix, (float)sliderPosition, (float)this.height, 100.0f).color(0, 0, 0, shadeColor).endVertex();
        buffer.vertex(matrix, (float)(sliderPosition + 4), (float)this.height, 100.0f).color(0, 0, 0, 0).endVertex();
        tesselator.end();
        buffer.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_COLOR);
        buffer.vertex(matrix, (float)(sliderPosition - 14), 0.0f, 100.0f).color(0, 0, 0, shadeColor /= 2).endVertex();
        buffer.vertex(matrix, (float)(sliderPosition - 14 - 4), 0.0f, 100.0f).color(0, 0, 0, 0).endVertex();
        buffer.vertex(matrix, (float)(sliderPosition - 14 - 4), (float)this.height, 100.0f).color(0, 0, 0, 0).endVertex();
        buffer.vertex(matrix, (float)(sliderPosition - 14), (float)this.height, 100.0f).color(0, 0, 0, shadeColor).endVertex();
        tesselator.end();
        RenderSystem.disableBlend();
        Rectangle slideArrowBounds = new Rectangle(sliderPosition - 14, 0, 14, this.height);
        MultiBufferSource.BufferSource immediate = MultiBufferSource.immediate((BufferBuilder)Tesselator.getInstance().getBuilder());
        this.font.renderText(">", (float)(sliderPosition - 7) - (float)this.font.width(">") / 2.0f, (float)(this.height / 2), (slideArrowBounds.contains(mouseX, mouseY) ? 0xFFFFA0 : 0xFFFFFF) | Mth.clamp((int)Mth.ceil((double)((1.0 - this.sideSlider.scrollAmount()) * 255.0)), (int)0, (int)255) << 24, false, graphics.pose().last().pose(), (MultiBufferSource)immediate, Font.DisplayMode.NORMAL, 0, 0xF000F0);
        this.font.renderText("<", (float)(sliderPosition - 7) - (float)this.font.width("<") / 2.0f, (float)(this.height / 2), (slideArrowBounds.contains(mouseX, mouseY) ? 0xFFFFA0 : 0xFFFFFF) | Mth.clamp((int)Mth.ceil((double)(this.sideSlider.scrollAmount() * 255.0)), (int)0, (int)255) << 24, false, graphics.pose().last().pose(), (MultiBufferSource)immediate, Font.DisplayMode.NORMAL, 0, 0xF000F0);
        immediate.endBatch();
        Rectangle scrollerBounds = this.sideScroller.getBounds();
        if (!scrollerBounds.isEmpty()) {
            ScissorsHandler.INSTANCE.scissor(new Rectangle(0, 0, sliderPosition - 14, this.height));
            int scrollOffset = scrollerBounds.y - this.sideScroller.scrollAmountInt();
            for (Reference reference : this.references) {
                graphics.pose().pushPose();
                graphics.pose().scale(reference.getScale(), reference.getScale(), reference.getScale());
                MutableComponent text = Component.literal((String)(StringUtils.repeat((String)"  ", (int)reference.getIndent()) + "- ")).append(reference.getText());
                if (this.lastHoveredReference == null) {
                    int n = scrollerBounds.x;
                    int n2 = (int)((float)scrollOffset - 4.0f * reference.getScale());
                    int n3 = (int)((float)this.font.width((FormattedText)text) * reference.getScale());
                    Objects.requireNonNull(this.font);
                    if (new Rectangle(n, n2, n3, (int)((float)(9 + 4) * reference.getScale())).contains(mouseX, mouseY)) {
                        this.lastHoveredReference = reference;
                    }
                }
                graphics.drawString(this.font, text.getVisualOrderText(), scrollerBounds.x, scrollOffset, this.lastHoveredReference == reference ? 16769544 : 0xFFFFFF, false);
                graphics.pose().popPose();
                float f = scrollOffset;
                Objects.requireNonNull(this.font);
                scrollOffset = (int)(f + (float)(9 + 3) * reference.getScale());
            }
            ScissorsHandler.INSTANCE.removeLastScissor();
            this.sideScroller.renderScrollBar(graphics);
        }
    }

    public void renderBackground(GuiGraphics guiGraphics, int i, int j, float f) {
    }

    @Override
    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        Rectangle slideBounds = new Rectangle(0, 0, this.getSideSliderPosition() - 14, this.height);
        if (button == 0 && slideBounds.contains(mouseX, mouseY) && this.lastHoveredReference != null) {
            this.minecraft.getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((Holder)SoundEvents.UI_BUTTON_CLICK, (float)1.0f));
            this.lastHoveredReference.go();
            return true;
        }
        Rectangle slideArrowBounds = new Rectangle(this.getSideSliderPosition() - 14, 0, 14, this.height);
        if (button == 0 && slideArrowBounds.contains(mouseX, mouseY)) {
            this.setExpanded(!this.isExpanded());
            this.minecraft.getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((Holder)SoundEvents.UI_BUTTON_CLICK, (float)1.0f));
            return true;
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    @Override
    public boolean isExpanded() {
        return this.sideSlider.scrollTarget() == 1.0;
    }

    @Override
    public void setExpanded(boolean expanded) {
        this.sideSlider.scrollTo(expanded ? 1.0 : 0.0, true, 2000L);
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double amountX, double amountY) {
        Rectangle slideBounds = new Rectangle(0, 0, this.getSideSliderPosition() - 14, this.height);
        if (amountY != 0.0 && slideBounds.contains(mouseX, mouseY)) {
            this.sideScroller.offset(ClothConfigInitializer.getScrollStep() * -amountY, true);
            return true;
        }
        return super.mouseScrolled(mouseX, mouseY, amountX, amountY);
    }

    private int getSideSliderPosition() {
        return (int)(this.sideSlider.scrollAmount() * (double)this.sideExpandLimit.get().intValue() + 14.0);
    }

    private static interface Reference {
        default public int getIndent() {
            return 0;
        }

        public Component getText();

        public float getScale();

        public void go();
    }

    private class ConfigEntryReference
    implements Reference {
        private final AbstractConfigEntry<?> entry;
        private final int layer;

        public ConfigEntryReference(AbstractConfigEntry<?> entry, int layer) {
            this.entry = entry;
            this.layer = layer;
        }

        @Override
        public int getIndent() {
            return this.layer;
        }

        @Override
        public Component getText() {
            return this.entry.getFieldName();
        }

        @Override
        public float getScale() {
            return 1.0f;
        }

        @Override
        public void go() {
            int[] i = new int[]{0};
            for (AbstractConfigEntry<AbstractConfigEntry<?>> child : GlobalizedClothConfigScreen.this.listWidget.children()) {
                int i1 = i[0];
                if (this.goChild(i, null, child)) {
                    return;
                }
                i[0] = i1 + child.getItemHeight();
            }
        }

        private boolean goChild(int[] i, Integer expandedParent, AbstractConfigEntry<?> root) {
            boolean expanded;
            if (root == this.entry) {
                GlobalizedClothConfigScreen.this.listWidget.scrollTo(expandedParent == null ? (double)i[0] : (double)expandedParent.intValue(), true);
                return true;
            }
            int j = i[0];
            i[0] = i[0] + root.getInitialReferenceOffset();
            boolean bl = expanded = root instanceof Expandable && ((Expandable)((Object)root)).isExpanded();
            if (root instanceof Expandable) {
                ((Expandable)((Object)root)).setExpanded(true);
            }
            List children = root.children();
            if (root instanceof Expandable) {
                ((Expandable)((Object)root)).setExpanded(expanded);
            }
            for (GuiEventListener child : children) {
                if (!(child instanceof ReferenceProvider)) continue;
                int i1 = i[0];
                if (this.goChild(i, expandedParent != null ? expandedParent : (root instanceof Expandable && !expanded ? Integer.valueOf(j) : null), ((ReferenceProvider)child).provideReferenceEntry())) {
                    return true;
                }
                i[0] = i1 + ((ReferenceProvider)child).provideReferenceEntry().getItemHeight();
            }
            return false;
        }
    }

    private class CategoryReference
    implements Reference {
        private final Component category;

        public CategoryReference(Component category) {
            this.category = category;
        }

        @Override
        public Component getText() {
            return this.category;
        }

        @Override
        public float getScale() {
            return 1.0f;
        }

        @Override
        public void go() {
            int i = 0;
            for (AbstractConfigEntry<AbstractConfigEntry<?>> child : GlobalizedClothConfigScreen.this.listWidget.children()) {
                if (child instanceof CategoryTextEntry && ((CategoryTextEntry)child).category == this.category) {
                    GlobalizedClothConfigScreen.this.listWidget.scrollTo(i, true);
                    return;
                }
                i += child.getItemHeight();
            }
        }
    }

    private static class CategoryTextEntry
    extends AbstractConfigListEntry<Object> {
        private final Component category;
        private final Component text;

        public CategoryTextEntry(Component category, Component text) {
            super((Component)Component.literal((String)UUID.randomUUID().toString()), false);
            this.category = category;
            this.text = text;
        }

        @Override
        public int getItemHeight() {
            List strings = Minecraft.getInstance().font.split((FormattedText)this.text, this.getParent().getItemWidth());
            if (strings.isEmpty()) {
                return 0;
            }
            return 4 + strings.size() * 10;
        }

        @Override
        @Nullable
        public ComponentPath nextFocusPath(FocusNavigationEvent focusNavigationEvent) {
            return null;
        }

        @Override
        public Object getValue() {
            return null;
        }

        @Override
        public Optional<Object> getDefaultValue() {
            return Optional.empty();
        }

        @Override
        public boolean isMouseInside(int mouseX, int mouseY, int x, int y, int entryWidth, int entryHeight) {
            return false;
        }

        @Override
        public void render(GuiGraphics graphics, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean isHovered, float delta) {
            super.render(graphics, index, y, x, entryWidth, entryHeight, mouseX, mouseY, isHovered, delta);
            int yy = y + 2;
            List texts = Minecraft.getInstance().font.split((FormattedText)this.text, this.getParent().getItemWidth());
            for (FormattedCharSequence text : texts) {
                graphics.drawString(Minecraft.getInstance().font, text, x - 4 + entryWidth / 2 - Minecraft.getInstance().font.width(text) / 2, yy, -1);
                yy += 10;
            }
        }

        public List<? extends GuiEventListener> children() {
            return Collections.emptyList();
        }

        @Override
        public List<? extends NarratableEntry> narratables() {
            return Collections.emptyList();
        }
    }
}

