/*
 * Decompiled with CFR 0.152.
 */
package dev.tr7zw.entityculling.config;

import com.mojang.serialization.Codec;
import java.util.Arrays;
import java.util.HashMap;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.Util;
import net.minecraft.client.OptionInstance;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.OptionsList;
import net.minecraft.client.gui.components.PlainTextButton;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;

public abstract class CustomConfigScreen
extends Screen {
    protected final Screen lastScreen;
    private OptionsList list;

    public CustomConfigScreen(Screen lastScreen, String title) {
        super((Component)Component.translatable((String)title));
        this.lastScreen = lastScreen;
    }

    public void removed() {
        this.save();
    }

    public void onClose() {
        this.minecraft.setScreen(this.lastScreen);
    }

    public OptionsList getOptions() {
        return this.list;
    }

    protected void init() {
        this.list = new OptionsList(this.minecraft, this.width, this.height - 64, 32, 25);
        this.addWidget((GuiEventListener)this.list);
        this.createFooter();
        this.initialize();
    }

    public abstract void initialize();

    public abstract void reset();

    public abstract void save();

    protected void createFooter() {
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)CommonComponents.GUI_DONE, (Button.OnPress)new Button.OnPress(){

            public void onPress(Button button) {
                CustomConfigScreen.this.onClose();
            }
        }).pos(this.width / 2 - 100, this.height - 27).size(200, 20).build());
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.translatable((String)"controls.reset"), (Button.OnPress)new Button.OnPress(){

            public void onPress(Button button) {
                CustomConfigScreen.this.reset();
                CustomConfigScreen.this.resize(CustomConfigScreen.this.minecraft, CustomConfigScreen.this.width, CustomConfigScreen.this.height);
            }
        }).pos(this.width / 2 + 110, this.height - 27).size(60, 20).build());
        this.addRenderableWidget((GuiEventListener)new PlainTextButton(5, 5, 400, 20, (Component)Component.literal((String)"Enjoying the mod? Consider supporting the developer!"), new Button.OnPress(){

            public void onPress(Button button) {
                Util.getPlatform().openUri("https://tr7zw.dev/donate/");
            }
        }, this.minecraft.font));
    }

    public void render(GuiGraphics guiGraphics, int i, int j, float f) {
        super.render(guiGraphics, i, j, f);
        this.list.render(guiGraphics, i, j, f);
        guiGraphics.drawCenteredString(this.font, this.title, this.width / 2, 20, 0xFFFFFF);
    }

    public void renderTransparentBackground(GuiGraphics guiGraphics) {
        this.renderDirtBackground(guiGraphics);
    }

    private <T> OptionInstance.TooltipSupplier<T> getOptionalTooltip(final String translationKey) {
        return new OptionInstance.TooltipSupplier<T>(){

            public Tooltip apply(T param1t) {
                MutableComponent comp;
                String key = translationKey + ".tooltip";
                if (key.equals((comp = Component.translatable((String)key)).getString())) {
                    return null;
                }
                return Tooltip.create((Component)comp);
            }
        };
    }

    public OptionInstance<Boolean> getBooleanOption(String translationKey, Supplier<Boolean> current, Consumer<Boolean> update) {
        return OptionInstance.createBoolean((String)translationKey, this.getOptionalTooltip(translationKey), (boolean)current.get(), update);
    }

    public OptionInstance<Boolean> getOnOffOption(String translationKey, Supplier<Boolean> current, Consumer<Boolean> update) {
        return this.getBooleanOption(translationKey, current, update);
    }

    public OptionInstance<Double> getDoubleOption(String translationKey, float min, float max, float steps, Supplier<Double> current, Consumer<Double> update) {
        Double sliderValue = (current.get() - (double)min) / (double)(max - min);
        return new OptionInstance(translationKey, this.getOptionalTooltip(translationKey), (comp, d) -> {
            double lvt_4_1_ = (double)min + d * (double)(max - min);
            lvt_4_1_ = (int)(lvt_4_1_ / (double)steps);
            return comp.copy().append(": " + CustomConfigScreen.round(lvt_4_1_ *= (double)steps, 3));
        }, (OptionInstance.ValueSet)OptionInstance.UnitDouble.INSTANCE, Codec.doubleRange((double)min, (double)max), (Object)sliderValue, d -> {
            double lvt_4_1_ = (double)min + d * (double)(max - min);
            lvt_4_1_ = (int)(lvt_4_1_ / (double)steps);
            update.accept(lvt_4_1_ *= (double)steps);
        });
    }

    public OptionInstance<Integer> getIntOption(String translationKey, int min, int max, Supplier<Integer> current, Consumer<Integer> update) {
        return new OptionInstance(translationKey, this.getOptionalTooltip(translationKey), (comp, d) -> comp.copy().append(": " + d), (OptionInstance.ValueSet)new OptionInstance.IntRange(min, max), (Object)current.get(), d -> update.accept((Integer)d));
    }

    public <T extends Enum> OptionInstance<T> getEnumOption(String translationKey, Class<T> targetEnum, Supplier<T> current, Consumer<T> update) {
        HashMap mapping = new HashMap();
        Arrays.asList((Enum[])targetEnum.getEnumConstants()).forEach(t -> mapping.put(t.name(), t));
        return new OptionInstance(translationKey, this.getOptionalTooltip(translationKey), (comp, t) -> Component.translatable((String)(translationKey + "." + t.name())), (OptionInstance.ValueSet)new OptionInstance.Enum(Arrays.asList((Enum[])targetEnum.getEnumConstants()), Codec.STRING.xmap(s -> (Enum)mapping.get(s), e -> e.name())), (Object)((Enum)current.get()), update);
    }

    public static double round(double value, int places) {
        if (places < 0) {
            throw new IllegalArgumentException();
        }
        long factor = (long)Math.pow(10.0, places);
        long tmp = Math.round(value *= (double)factor);
        return (double)tmp / (double)factor;
    }
}

