/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.client.gui;

import com.google.gson.FieldNamingPolicy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.annotations.SerializedName;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import me.jellysquid.mods.sodium.client.gui.options.TextProvider;
import me.jellysquid.mods.sodium.client.util.FileUtil;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_2561;
import net.minecraft.class_5365;

public class SodiumGameOptions {
    private static final String DEFAULT_FILE_NAME = "sodium-options.json";
    public final QualitySettings quality = new QualitySettings();
    public final AdvancedSettings advanced = new AdvancedSettings();
    public final PerformanceSettings performance = new PerformanceSettings();
    public final NotificationSettings notifications = new NotificationSettings();
    private boolean readOnly;
    private static final Gson GSON = new GsonBuilder().setFieldNamingPolicy(FieldNamingPolicy.LOWER_CASE_WITH_UNDERSCORES).setPrettyPrinting().excludeFieldsWithModifiers(new int[]{2}).create();

    private SodiumGameOptions() {
    }

    public static SodiumGameOptions defaults() {
        return new SodiumGameOptions();
    }

    public static SodiumGameOptions loadFromDisk() {
        SodiumGameOptions config;
        block10: {
            Path path = SodiumGameOptions.getConfigPath();
            if (Files.exists(path, new LinkOption[0])) {
                try (FileReader reader = new FileReader(path.toFile());){
                    config = (SodiumGameOptions)GSON.fromJson((Reader)reader, SodiumGameOptions.class);
                    break block10;
                }
                catch (IOException e) {
                    throw new RuntimeException("Could not parse config", e);
                }
            }
            config = new SodiumGameOptions();
        }
        try {
            SodiumGameOptions.writeToDisk(config);
        }
        catch (IOException e) {
            throw new RuntimeException("Couldn't update config file", e);
        }
        return config;
    }

    private static Path getConfigPath() {
        return FabricLoader.getInstance().getConfigDir().resolve(DEFAULT_FILE_NAME);
    }

    public static void writeToDisk(SodiumGameOptions config) throws IOException {
        if (config.isReadOnly()) {
            throw new IllegalStateException("Config file is read-only");
        }
        Path path = SodiumGameOptions.getConfigPath();
        Path dir = path.getParent();
        if (!Files.exists(dir, new LinkOption[0])) {
            Files.createDirectories(dir, new FileAttribute[0]);
        } else if (!Files.isDirectory(dir, new LinkOption[0])) {
            throw new IOException("Not a directory: " + dir);
        }
        FileUtil.writeTextRobustly(GSON.toJson((Object)config), path);
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public void setReadOnly() {
        this.readOnly = true;
    }

    public static class QualitySettings {
        public GraphicsQuality weatherQuality = GraphicsQuality.DEFAULT;
        public GraphicsQuality leavesQuality = GraphicsQuality.DEFAULT;
        public boolean enableVignette = true;
    }

    public static class AdvancedSettings {
        public boolean enableMemoryTracing = false;
        public boolean useAdvancedStagingBuffers = true;
        public int cpuRenderAheadLimit = 3;
    }

    public static class PerformanceSettings {
        public int chunkBuilderThreads = 0;
        @SerializedName(value="always_defer_chunk_updates_v2")
        public boolean alwaysDeferChunkUpdates = true;
        public boolean animateOnlyVisibleTextures = true;
        public boolean useEntityCulling = true;
        public boolean useFogOcclusion = true;
        public boolean useBlockFaceCulling = true;
        public boolean useNoErrorGLContext = true;
    }

    public static class NotificationSettings {
        public boolean hasClearedDonationButton = false;
        public boolean hasSeenDonationPrompt = false;
    }

    public static enum GraphicsQuality implements TextProvider
    {
        DEFAULT("options.gamma.default"),
        FANCY("options.clouds.fancy"),
        FAST("options.clouds.fast");

        private final class_2561 name;

        private GraphicsQuality(String name) {
            this.name = class_2561.method_43471((String)name);
        }

        @Override
        public class_2561 getLocalizedName() {
            return this.name;
        }

        public boolean isFancy(class_5365 graphicsMode) {
            return this == FANCY || this == DEFAULT && (graphicsMode == class_5365.field_25428 || graphicsMode == class_5365.field_25429);
        }
    }
}

