/*
 * Decompiled with CFR 0.152.
 */
package com.terraformersmc.modmenu.gui.widget.entries;

import com.mojang.blaze3d.systems.RenderSystem;
import com.terraformersmc.modmenu.ModMenu;
import com.terraformersmc.modmenu.config.ModMenuConfig;
import com.terraformersmc.modmenu.gui.widget.ModListWidget;
import com.terraformersmc.modmenu.gui.widget.UpdateAvailableBadge;
import com.terraformersmc.modmenu.gui.widget.entries.ParentEntry;
import com.terraformersmc.modmenu.util.DrawingUtil;
import com.terraformersmc.modmenu.util.ModMenuScreenTexts;
import com.terraformersmc.modmenu.util.mod.Mod;
import com.terraformersmc.modmenu.util.mod.ModBadgeRenderer;
import java.util.Objects;
import net.minecraft.class_1043;
import net.minecraft.class_1044;
import net.minecraft.class_156;
import net.minecraft.class_2477;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_4280;
import net.minecraft.class_5250;
import net.minecraft.class_5348;

public class ModListEntry
extends class_4280.class_4281<ModListEntry> {
    public static final class_2960 UNKNOWN_ICON = new class_2960("textures/misc/unknown_pack.png");
    private static final class_2960 MOD_CONFIGURATION_ICON = new class_2960("modmenu", "textures/gui/mod_configuration.png");
    private static final class_2960 ERROR_ICON = new class_2960("minecraft", "world_list/error");
    private static final class_2960 ERROR_HIGHLIGHTED_ICON = new class_2960("minecraft", "world_list/error_highlighted");
    protected final class_310 client;
    public final Mod mod;
    protected final ModListWidget list;
    protected class_2960 iconLocation;
    protected static final int FULL_ICON_SIZE = 32;
    protected static final int COMPACT_ICON_SIZE = 19;
    protected long sinceLastClick;

    public ModListEntry(Mod mod, ModListWidget list) {
        this.mod = mod;
        this.list = list;
        this.client = class_310.method_1551();
    }

    public class_2561 method_37006() {
        return class_2561.method_43470((String)this.mod.getTranslatedName());
    }

    public void method_25343(class_332 DrawContext, int index, int y, int x, int rowWidth, int rowHeight, int mouseX, int mouseY, boolean hovered, float delta) {
        class_5250 name;
        x += this.getXOffset();
        rowWidth -= this.getXOffset();
        int iconSize = ModMenuConfig.COMPACT_LIST.getValue() ? 19 : 32;
        String modId = this.mod.getId();
        if ("java".equals(modId)) {
            DrawingUtil.drawRandomVersionBackground(this.mod, DrawContext, x, y, iconSize, iconSize);
        }
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.enableBlend();
        DrawContext.method_25290(this.getIconTexture(), x, y, 0.0f, 0.0f, iconSize, iconSize, iconSize, iconSize);
        RenderSystem.disableBlend();
        class_5250 trimmedName = name = class_2561.method_43470((String)this.mod.getTranslatedName());
        int maxNameWidth = rowWidth - iconSize - 3;
        class_327 font = this.client.field_1772;
        if (font.method_27525((class_5348)name) > maxNameWidth) {
            class_5348 ellipsis = class_5348.method_29430((String)"...");
            trimmedName = class_5348.method_29433((class_5348[])new class_5348[]{font.method_1714((class_5348)name, maxNameWidth - font.method_27525(ellipsis)), ellipsis});
        }
        DrawContext.method_51430(font, class_2477.method_10517().method_30934((class_5348)trimmedName), x + iconSize + 3, y + 1, 0xFFFFFF, false);
        int updateBadgeXOffset = 0;
        if (ModMenuConfig.UPDATE_CHECKER.getValue() && !ModMenuConfig.DISABLE_UPDATE_CHECKER.getValue().contains(modId) && (this.mod.getModrinthData() != null || this.mod.getChildHasUpdate())) {
            UpdateAvailableBadge.renderBadge(DrawContext, x + iconSize + 3 + font.method_27525((class_5348)name) + 2, y);
            updateBadgeXOffset = 11;
        }
        if (!ModMenuConfig.HIDE_BADGES.getValue()) {
            new ModBadgeRenderer(x + iconSize + 3 + font.method_27525((class_5348)name) + 2 + updateBadgeXOffset, y, x + rowWidth, this.mod, this.list.getParent()).draw(DrawContext, mouseX, mouseY);
        }
        if (!ModMenuConfig.COMPACT_LIST.getValue()) {
            String summary = this.mod.getSummary();
            Objects.requireNonNull(this.client.field_1772);
            DrawingUtil.drawWrappedString(DrawContext, summary, x + iconSize + 3 + 4, y + 9 + 2, rowWidth - iconSize - 7, 2, 0x808080);
        } else {
            String string = this.mod.getPrefixedVersion();
            Objects.requireNonNull(this.client.field_1772);
            DrawingUtil.drawWrappedString(DrawContext, string, x + iconSize + 3, y + 9 + 2, rowWidth - iconSize - 7, 2, 0x808080);
        }
        if (!(this instanceof ParentEntry) && ModMenuConfig.QUICK_CONFIGURE.getValue() && (this.list.getParent().getModHasConfigScreen().get(modId).booleanValue() || this.list.getParent().modScreenErrors.containsKey(modId))) {
            int textureSize;
            int n = textureSize = ModMenuConfig.COMPACT_LIST.getValue() ? 152 : 256;
            if (((Boolean)this.client.field_1690.method_42446().method_41753()).booleanValue() || hovered) {
                boolean hoveringIcon;
                DrawContext.method_25294(x, y, x + iconSize, y + iconSize, -1601138544);
                boolean bl = hoveringIcon = mouseX - x < iconSize;
                if (this.list.getParent().modScreenErrors.containsKey(modId)) {
                    DrawContext.method_52706(hoveringIcon ? ERROR_HIGHLIGHTED_ICON : ERROR_ICON, x, y, iconSize, iconSize);
                    if (hoveringIcon) {
                        Throwable e = this.list.getParent().modScreenErrors.get(modId);
                        this.list.getParent().method_47414(this.client.field_1772.method_1728((class_5348)ModMenuScreenTexts.configureError(modId, e), 175));
                    }
                } else {
                    int v = hoveringIcon ? iconSize : 0;
                    DrawContext.method_25290(MOD_CONFIGURATION_ICON, x, y, 0.0f, (float)v, iconSize, iconSize, textureSize, textureSize);
                }
            }
        }
    }

    public boolean method_25402(double mouseX, double mouseY, int delta) {
        this.list.select(this);
        if (ModMenuConfig.QUICK_CONFIGURE.getValue() && this.list.getParent().getModHasConfigScreen().get(this.mod.getId()).booleanValue()) {
            int iconSize;
            int n = iconSize = ModMenuConfig.COMPACT_LIST.getValue() ? 19 : 32;
            if (mouseX - (double)this.list.method_25342() <= (double)iconSize) {
                this.openConfig();
            } else if (class_156.method_658() - this.sinceLastClick < 250L) {
                this.openConfig();
            }
        }
        this.sinceLastClick = class_156.method_658();
        return true;
    }

    public void openConfig() {
        class_310.method_1551().method_1507(ModMenu.getConfigScreen(this.mod.getId(), this.list.getParent()));
    }

    public Mod getMod() {
        return this.mod;
    }

    public class_2960 getIconTexture() {
        if (this.iconLocation == null) {
            this.iconLocation = new class_2960("modmenu", this.mod.getId() + "_icon");
            class_1043 icon = this.mod.getIcon(this.list.getFabricIconHandler(), 64 * (Integer)this.client.field_1690.method_42474().method_41753());
            if (icon != null) {
                this.client.method_1531().method_4616(this.iconLocation, (class_1044)icon);
            } else {
                this.iconLocation = UNKNOWN_ICON;
            }
        }
        return this.iconLocation;
    }

    public int getXOffset() {
        return 0;
    }
}

