/*
 * Decompiled with CFR 0.152.
 */
package com.ishland.vmp.common.chunkwatching;

import com.ishland.vmp.common.chunkwatching.PlayerClientVDTracking;
import com.ishland.vmp.common.maps.AreaMap;
import io.papermc.paper.util.MCUtil;
import it.unimi.dsi.fastutil.objects.Object2LongMap;
import it.unimi.dsi.fastutil.objects.Object2LongOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.util.Arrays;
import java.util.Set;
import net.minecraft.class_1311;
import net.minecraft.class_1923;
import net.minecraft.class_3222;
import net.minecraft.class_3532;
import net.minecraft.class_3898;
import net.minecraft.class_8603;

public class AreaPlayerChunkWatchingManager {
    public static final int GENERAL_PLAYER_AREA_MAP_DISTANCE = (int)Math.ceil((double)Arrays.stream(class_1311.values()).mapToInt(class_1311::method_27919).reduce(0, Math::max) / 16.0);
    private final AreaMap<class_3222> playerAreaMap;
    private final AreaMap<class_3222> generalPlayerAreaMap = new AreaMap();
    private final Object2LongOpenHashMap<class_3222> positions = new Object2LongOpenHashMap();
    private Listener addListener = null;
    private Listener removeListener = null;
    private int watchDistance = 5;

    public AreaPlayerChunkWatchingManager() {
        this(null, null, null);
    }

    public AreaPlayerChunkWatchingManager(Listener addListener, Listener removeListener, class_3898 tacs) {
        this.addListener = addListener;
        this.removeListener = removeListener;
        this.playerAreaMap = new AreaMap<class_3222>((object, x, z) -> {
            if (this.addListener != null) {
                this.addListener.accept((class_3222)object, x, z);
            }
        }, (object, x, z) -> {
            if (this.removeListener != null) {
                this.removeListener.accept((class_3222)object, x, z);
            }
        }, true);
    }

    public void tick() {
        for (Object2LongMap.Entry entry : this.positions.object2LongEntrySet()) {
            class_3222 player = (class_3222)entry.getKey();
            PlayerClientVDTracking vdTracking = (PlayerClientVDTracking)player;
            if (!vdTracking.isClientViewDistanceChanged()) continue;
            vdTracking.getClientViewDistance();
            long pos = entry.getLongValue();
            player.method_52373(class_8603.method_52362((class_1923)new class_1923(pos), (int)this.getViewDistance(player)));
            this.movePlayer(pos, player);
        }
    }

    public void setWatchDistance(int watchDistance) {
        this.watchDistance = Math.max(2, watchDistance);
        ObjectIterator iterator = this.positions.object2LongEntrySet().fastIterator();
        while (iterator.hasNext()) {
            Object2LongMap.Entry entry = (Object2LongMap.Entry)iterator.next();
            ((class_3222)entry.getKey()).method_52373(class_8603.method_52362((class_1923)new class_1923(entry.getLongValue()), (int)this.getViewDistance((class_3222)entry.getKey())));
            this.playerAreaMap.update((class_3222)entry.getKey(), MCUtil.getCoordinateX(entry.getLongValue()), MCUtil.getCoordinateZ(entry.getLongValue()), this.getViewDistance((class_3222)entry.getKey()));
            this.generalPlayerAreaMap.update((class_3222)entry.getKey(), MCUtil.getCoordinateX(entry.getLongValue()), MCUtil.getCoordinateZ(entry.getLongValue()), GENERAL_PLAYER_AREA_MAP_DISTANCE);
        }
    }

    public int getWatchDistance() {
        return this.watchDistance;
    }

    public Set<class_3222> getPlayersWatchingChunk(long l) {
        return this.playerAreaMap.getObjectsInRange(l);
    }

    public Object[] getPlayersWatchingChunkArray(long coordinateKey) {
        return this.playerAreaMap.getObjectsInRangeArray(coordinateKey);
    }

    public Object[] getPlayersInGeneralAreaMap(long coordinateKey) {
        return this.generalPlayerAreaMap.getObjectsInRangeArray(coordinateKey);
    }

    public void add(class_3222 player, long pos) {
        int x = class_1923.method_8325((long)pos);
        int z = class_1923.method_8332((long)pos);
        this.playerAreaMap.add(player, x, z, this.getViewDistance(player));
        this.generalPlayerAreaMap.add(player, x, z, GENERAL_PLAYER_AREA_MAP_DISTANCE);
        this.positions.put((Object)player, MCUtil.getCoordinateKey(x, z));
    }

    public void remove(class_3222 player) {
        this.playerAreaMap.remove(player);
        this.generalPlayerAreaMap.remove(player);
        this.positions.removeLong((Object)player);
    }

    public void movePlayer(long currentPos, class_3222 player) {
        int x = class_1923.method_8325((long)currentPos);
        int z = class_1923.method_8332((long)currentPos);
        this.playerAreaMap.update(player, x, z, this.getViewDistance(player));
        this.generalPlayerAreaMap.update(player, x, z, GENERAL_PLAYER_AREA_MAP_DISTANCE);
        this.positions.put((Object)player, MCUtil.getCoordinateKey(x, z));
    }

    private int getViewDistance(class_3222 player) {
        return class_3532.method_15340((int)player.method_52371(), (int)2, (int)this.watchDistance) + 1;
    }

    public static interface Listener {
        public void accept(class_3222 var1, int var2, int var3);
    }
}

