/*
 * Decompiled with CFR 0.152.
 */
package ca.fxco.moreculling.utils;

import ca.fxco.moreculling.api.data.QuadBounds;
import net.fabricmc.fabric.impl.client.indigo.renderer.mesh.EncodingFormat;
import net.minecraft.class_2350;
import net.minecraft.class_777;
import org.joml.Math;
import org.joml.Matrix4f;
import org.joml.Vector2f;
import org.joml.Vector2i;
import org.joml.Vector2ic;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class VertexUtils {
    public static final float FAST_NORM = 0.0625f;

    public static boolean isTriangleInvisible(Vector3f p0, Vector3f p1, Vector3f p2) {
        return p1.sub((Vector3fc)p0).cross((Vector3fc)p2.sub((Vector3fc)p0)).dot((Vector3fc)p0) >= 0.0f;
    }

    public static Vector3f applyTransformation(Vector3f vector, Matrix4f matrix) {
        float x2 = vector.x() * 0.0625f;
        float y2 = vector.y() * 0.0625f;
        float z2 = vector.z() * 0.0625f;
        return new Vector3f(Math.fma((float)matrix.m00(), (float)x2, (float)Math.fma((float)matrix.m10(), (float)y2, (float)Math.fma((float)matrix.m20(), (float)z2, (float)matrix.m30()))), Math.fma((float)matrix.m01(), (float)x2, (float)Math.fma((float)matrix.m11(), (float)y2, (float)Math.fma((float)matrix.m21(), (float)z2, (float)matrix.m31()))), Math.fma((float)matrix.m02(), (float)x2, (float)Math.fma((float)matrix.m12(), (float)y2, (float)Math.fma((float)matrix.m22(), (float)z2, (float)matrix.m32()))));
    }

    private static Vector3f getPos(int[] data, int vertexIndex) {
        int index = vertexIndex * EncodingFormat.VERTEX_STRIDE;
        return new Vector3f(Float.intBitsToFloat(data[index]), Float.intBitsToFloat(data[index + 1]), Float.intBitsToFloat(data[index + 2]));
    }

    private static Vector2f getPos(int[] data, int vertexIndex, class_2350.class_2351 axis) {
        int index = vertexIndex * EncodingFormat.VERTEX_STRIDE;
        if (axis.method_10178()) {
            return new Vector2f(Float.intBitsToFloat(data[index]), Float.intBitsToFloat(data[index + 2]));
        }
        return new Vector2f((float)axis.method_10172((double)Float.intBitsToFloat(data[index + 2]), 0.0, (double)Float.intBitsToFloat(data[index])), Float.intBitsToFloat(data[index + 1]));
    }

    public static QuadBounds getQuadBounds(class_777 quad, class_2350.class_2351 axis) {
        Vector2i minPos = new Vector2i(Integer.MAX_VALUE);
        Vector2i maxPos = new Vector2i(-2147483647);
        int[] vertexData = quad.method_3357();
        for (int i = 0; i < 4; ++i) {
            Vector2f tmpPos = VertexUtils.getPos(vertexData, i, axis).mul(16.0f);
            Vector2i pos = new Vector2i(Math.round((float)tmpPos.x), Math.round((float)tmpPos.y));
            minPos.min((Vector2ic)pos);
            maxPos.max((Vector2ic)pos);
        }
        return new QuadBounds(minPos.x, minPos.y, maxPos.x, maxPos.y);
    }

    public static boolean isAxisAligned(class_777 quad) {
        int[] vertexData = quad.method_3357();
        Vector3f p1 = VertexUtils.getPos(vertexData, 0);
        Vector3f p4 = VertexUtils.getPos(vertexData, 3);
        if (p1.y == p4.y) {
            Vector3f p2 = VertexUtils.getPos(vertexData, 1);
            Vector3f p3 = VertexUtils.getPos(vertexData, 2);
            return p2.y == p3.y && (p1.y == p2.y || p1.x == p3.x || p1.z == p3.z);
        }
        return false;
    }
}

