/*
 * Decompiled with CFR 0.152.
 */
package ca.fxco.moreculling.config.sodium;

import ca.fxco.moreculling.api.config.ConfigAdditions;
import com.mojang.datafixers.util.Pair;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.function.BiConsumer;
import java.util.function.Function;
import me.jellysquid.mods.sodium.client.gui.options.Option;
import me.jellysquid.mods.sodium.client.gui.options.OptionFlag;
import me.jellysquid.mods.sodium.client.gui.options.OptionImpact;
import me.jellysquid.mods.sodium.client.gui.options.binding.GenericBinding;
import me.jellysquid.mods.sodium.client.gui.options.binding.OptionBinding;
import me.jellysquid.mods.sodium.client.gui.options.control.Control;
import me.jellysquid.mods.sodium.client.gui.options.storage.OptionStorage;
import net.minecraft.class_2561;
import org.apache.commons.lang3.Validate;
import org.jetbrains.annotations.Nullable;

public class MoreCullingSodiumOptionImpl<S, T>
implements Option<T> {
    protected final OptionStorage<S> storage;
    protected final OptionBinding<S, T> binding;
    protected final Control<T> control;
    protected BiConsumer<MoreCullingSodiumOptionImpl<S, T>, T> onChanged;
    protected final EnumSet<OptionFlag> flags;
    protected final class_2561 name;
    protected final class_2561 tooltip;
    protected final OptionImpact impact;
    protected T value;
    protected T modifiedValue;
    protected boolean enabled;
    private final boolean locked;

    protected MoreCullingSodiumOptionImpl(OptionStorage<S> storage, class_2561 name, class_2561 tooltip, OptionBinding<S, T> binding, Function<MoreCullingSodiumOptionImpl<S, T>, Control<T>> control, EnumSet<OptionFlag> flags, OptionImpact impact, BiConsumer<MoreCullingSodiumOptionImpl<S, T>, T> onChanged, boolean enabled) {
        this(storage, name, tooltip, binding, control, flags, impact, onChanged, enabled, false);
    }

    protected MoreCullingSodiumOptionImpl(OptionStorage<S> storage, class_2561 name, class_2561 tooltip, OptionBinding<S, T> binding, Function<MoreCullingSodiumOptionImpl<S, T>, Control<T>> control, EnumSet<OptionFlag> flags, OptionImpact impact, BiConsumer<MoreCullingSodiumOptionImpl<S, T>, T> onChanged, boolean enabled, boolean locked) {
        this.storage = storage;
        this.name = name;
        this.tooltip = tooltip;
        this.binding = binding;
        this.impact = impact;
        this.flags = flags;
        this.control = control.apply(this);
        this.onChanged = onChanged;
        this.enabled = enabled;
        this.locked = locked;
        this.reset();
    }

    public class_2561 getName() {
        return this.name;
    }

    public class_2561 getTooltip() {
        return this.tooltip;
    }

    public OptionImpact getImpact() {
        return this.impact;
    }

    public Control<T> getControl() {
        return this.control;
    }

    public T getValue() {
        return this.modifiedValue;
    }

    public void setValue(T value) {
        if (this.locked) {
            return;
        }
        this.modifiedValue = value;
        if (this.onChanged != null) {
            this.onChanged.accept(this, (MoreCullingSodiumOptionImpl)this.getValue());
        }
    }

    public void reset() {
        this.value = this.binding.getValue(this.storage.getData());
        this.modifiedValue = this.value;
        if (this.onChanged != null) {
            this.onChanged.accept(this, (MoreCullingSodiumOptionImpl)this.getValue());
        }
    }

    public OptionStorage<?> getStorage() {
        return this.storage;
    }

    public boolean isAvailable() {
        return this.enabled;
    }

    public void setAvailable(boolean available) {
        if (this.locked) {
            return;
        }
        this.enabled = available;
        if (this.onChanged != null) {
            this.onChanged.accept(this, (MoreCullingSodiumOptionImpl)this.getValue());
        }
    }

    public void setOnChanged(BiConsumer<MoreCullingSodiumOptionImpl<S, T>, T> onChanged) {
        if (this.locked) {
            return;
        }
        this.onChanged = onChanged;
    }

    public boolean hasChanged() {
        return !this.value.equals(this.modifiedValue);
    }

    public void applyChanges() {
        if (this.locked) {
            return;
        }
        if (this.enabled) {
            this.binding.setValue(this.storage.getData(), this.modifiedValue);
            this.value = this.modifiedValue;
        }
    }

    public Collection<OptionFlag> getFlags() {
        return this.flags;
    }

    public static <S, T> Builder<S, T> createBuilder(Class<T> type, OptionStorage<S> storage) {
        return new Builder(storage);
    }

    public static class Builder<S, T> {
        private final OptionStorage<S> storage;
        private String nameTranslationKey;
        private class_2561 tooltip;
        private OptionBinding<S, T> binding;
        private Function<MoreCullingSodiumOptionImpl<S, T>, Control<T>> control;
        private OptionImpact impact;
        private final EnumSet<OptionFlag> flags = EnumSet.noneOf(OptionFlag.class);
        @Nullable
        private BiConsumer<MoreCullingSodiumOptionImpl<S, T>, T> onChanged;
        private boolean enabled = true;
        private boolean locked = false;

        private Builder(OptionStorage<S> storage) {
            this.storage = storage;
        }

        public Builder<S, T> setNameTranslation(String translationKey) {
            this.nameTranslationKey = translationKey;
            return this;
        }

        public Builder<S, T> setTooltip(@Nullable class_2561 tooltip) {
            if (!this.locked) {
                this.tooltip = tooltip;
            }
            return this;
        }

        public Builder<S, T> setBinding(BiConsumer<S, T> setter, Function<S, T> getter) {
            Validate.notNull(setter, (String)"Setter must not be null", (Object[])new Object[0]);
            Validate.notNull(getter, (String)"Getter must not be null", (Object[])new Object[0]);
            this.binding = new GenericBinding(setter, getter);
            return this;
        }

        public Builder<S, T> setBinding(OptionBinding<S, T> binding) {
            Validate.notNull(binding, (String)"Argument must not be null", (Object[])new Object[0]);
            this.binding = binding;
            return this;
        }

        public Builder<S, T> setControl(Function<MoreCullingSodiumOptionImpl<S, T>, Control<T>> control) {
            Validate.notNull(control, (String)"Argument must not be null", (Object[])new Object[0]);
            this.control = control;
            return this;
        }

        public Builder<S, T> setImpact(OptionImpact impact) {
            this.impact = impact;
            return this;
        }

        public Builder<S, T> onChanged(BiConsumer<MoreCullingSodiumOptionImpl<S, T>, T> biconsumer) {
            Validate.notNull(biconsumer, (String)"BiConsumer must not be null", (Object[])new Object[0]);
            if (!this.locked) {
                this.onChanged = biconsumer;
            }
            return this;
        }

        public Builder<S, T> setEnabled(boolean value) {
            if (!this.locked) {
                this.enabled = value;
            }
            return this;
        }

        public Builder<S, T> setFlags(OptionFlag ... flags) {
            Collections.addAll(this.flags, flags);
            return this;
        }

        public Builder<S, T> setModIncompatibility(boolean isLoaded, String modId) {
            if (isLoaded) {
                this.locked = true;
                this.enabled = false;
                this.tooltip = class_2561.method_43469((String)"moreculling.config.optionDisabled", (Object[])new Object[]{modId});
                this.onChanged = null;
            }
            return this;
        }

        public Builder<S, T> setModLimited(boolean isLoaded, class_2561 limitedMessage) {
            if (isLoaded) {
                this.tooltip = this.tooltip != null ? this.tooltip.method_27661().method_27693("\n").method_10852(limitedMessage) : limitedMessage;
            }
            return this;
        }

        public MoreCullingSodiumOptionImpl<S, T> build() {
            Validate.notNull((Object)this.nameTranslationKey, (String)"Name must be specified", (Object[])new Object[0]);
            Validate.notNull((Object)this.tooltip, (String)"Tooltip must be specified", (Object[])new Object[0]);
            Validate.notNull(this.binding, (String)"Option binding must be specified", (Object[])new Object[0]);
            Validate.notNull(this.control, (String)"Control must be specified", (Object[])new Object[0]);
            Pair<String, Function<?, ?>> pair = ConfigAdditions.getDisabledOptions().get(this.nameTranslationKey);
            if (pair != null) {
                this.locked = true;
                this.enabled = false;
                this.tooltip = class_2561.method_43470((String)((String)pair.getFirst()));
                this.onChanged = null;
                Function func1 = (Function)pair.getSecond();
                if (func1 != null) {
                    Function func2 = func1;
                    this.binding.setValue(this.storage.getData(), func2.apply(this.binding.getValue(this.storage.getData())));
                }
            }
            return new MoreCullingSodiumOptionImpl<S, T>(this.storage, (class_2561)class_2561.method_43471((String)this.nameTranslationKey), this.tooltip, this.binding, this.control, this.flags, this.impact, this.onChanged, this.enabled, this.locked);
        }
    }
}

