/*
 * Decompiled with CFR 0.152.
 */
package org.iq80.leveldb.util;

import java.time.LocalDateTime;
import java.util.function.Supplier;

public final class LogMessageFormatter {
    private static final int DATE_SIZE = 28;
    private final Supplier<LocalDateTime> clock;

    public LogMessageFormatter(Supplier<LocalDateTime> clock) {
        this.clock = clock;
    }

    public String format(String message) {
        StringBuilder sb = new StringBuilder(message.length() + 28);
        sb.append(this.clock.get());
        sb.append(' ');
        sb.append(message);
        return sb.toString();
    }

    public String format(String template, Object[] args) {
        int placeholderStart;
        template = String.valueOf(template);
        StringBuilder builder = new StringBuilder(28 + template.length() + 16 * args.length);
        builder.append(this.clock.get());
        builder.append(" ");
        int templateStart = 0;
        int i = 0;
        while (i < args.length && (placeholderStart = template.indexOf("%s", templateStart)) != -1) {
            builder.append(template, templateStart, placeholderStart);
            builder.append(args[i++]);
            templateStart = placeholderStart + 2;
        }
        builder.append(template, templateStart, template.length());
        if (i < args.length) {
            builder.append(" [");
            builder.append(args[i++]);
            while (i < args.length) {
                builder.append(", ");
                builder.append(args[i++]);
            }
            builder.append(']');
        }
        return builder.toString();
    }
}

