/*
 * Decompiled with CFR 0.152.
 */
package org.iq80.leveldb.util;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import org.iq80.leveldb.util.Slice;
import org.iq80.leveldb.util.SliceInput;
import org.iq80.leveldb.util.SliceOutput;
import org.iq80.leveldb.util.Slices;

public class DynamicSliceOutput
extends SliceOutput {
    private Slice slice;
    private int size;

    public DynamicSliceOutput(int estimatedSize) {
        this.slice = new Slice(estimatedSize);
    }

    @Override
    public void reset() {
        this.size = 0;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isWritable() {
        return this.writableBytes() > 0;
    }

    @Override
    public int writableBytes() {
        return this.slice.length() - this.size;
    }

    @Override
    public void writeByte(int value) {
        this.slice = Slices.ensureSize(this.slice, this.size + 1);
        this.slice.setByte(this.size++, value);
    }

    @Override
    public void writeShort(int value) {
        this.slice = Slices.ensureSize(this.slice, this.size + 2);
        this.slice.setShort(this.size, value);
        this.size += 2;
    }

    @Override
    public void writeInt(int value) {
        this.slice = Slices.ensureSize(this.slice, this.size + 4);
        this.slice.setInt(this.size, value);
        this.size += 4;
    }

    @Override
    public void writeLong(long value) {
        this.slice = Slices.ensureSize(this.slice, this.size + 8);
        this.slice.setLong(this.size, value);
        this.size += 8;
    }

    @Override
    public void writeBytes(byte[] source) {
        this.writeBytes(source, 0, source.length);
    }

    @Override
    public void writeBytes(byte[] source, int sourceIndex, int length) {
        this.slice = Slices.ensureSize(this.slice, this.size + length);
        this.slice.setBytes(this.size, source, sourceIndex, length);
        this.size += length;
    }

    @Override
    public void writeBytes(Slice source) {
        this.writeBytes(source, 0, source.length());
    }

    @Override
    public void writeBytes(SliceInput source, int length) {
        if (length > source.available()) {
            throw new IndexOutOfBoundsException();
        }
        this.writeBytes(source.slice());
    }

    @Override
    public void writeBytes(Slice source, int sourceIndex, int length) {
        this.slice = Slices.ensureSize(this.slice, this.size + length);
        this.slice.setBytes(this.size, source, sourceIndex, length);
        this.size += length;
    }

    @Override
    public void writeBytes(ByteBuffer source) {
        int length = source.remaining();
        this.slice = Slices.ensureSize(this.slice, this.size + length);
        this.slice.setBytes(this.size, source);
        this.size += length;
    }

    @Override
    public int writeBytes(InputStream in, int length) throws IOException {
        this.slice = Slices.ensureSize(this.slice, this.size + length);
        int writtenBytes = this.slice.setBytes(this.size, in, length);
        if (writtenBytes > 0) {
            this.size += writtenBytes;
        }
        return writtenBytes;
    }

    @Override
    public void writeZero(int length) {
        int i;
        if (length == 0) {
            return;
        }
        if (length < 0) {
            throw new IllegalArgumentException("length must be 0 or greater than 0.");
        }
        this.slice = Slices.ensureSize(this.slice, this.size + length);
        int nLong = length >>> 3;
        int nBytes = length & 7;
        for (i = nLong; i > 0; --i) {
            this.writeLong(0L);
        }
        if (nBytes == 4) {
            this.writeInt(0);
        } else if (nBytes < 4) {
            for (i = nBytes; i > 0; --i) {
                this.writeByte(0);
            }
        } else {
            this.writeInt(0);
            for (i = nBytes - 4; i > 0; --i) {
                this.writeByte(0);
            }
        }
    }

    @Override
    public Slice slice() {
        return this.slice.slice(0, this.size);
    }

    @Override
    public ByteBuffer toByteBuffer() {
        return this.slice.toByteBuffer(0, this.size);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(size=" + this.size + ", capacity=" + this.slice.length() + ")";
    }

    @Override
    public String toString(Charset charset) {
        return this.slice.toString(0, this.size, charset);
    }
}

