/*
 * Decompiled with CFR 0.152.
 */
package org.iq80.leveldb.util;

import com.google.common.base.Throwables;
import java.io.Closeable;
import java.io.IOException;
import java.util.concurrent.Callable;

public final class Closeables {
    private Closeables() {
    }

    public static void closeQuietly(Closeable closeable) {
        if (closeable == null) {
            return;
        }
        try {
            closeable.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void closeAll(Iterable<? extends Closeable> closeables) throws IOException {
        Throwable throwable = null;
        for (Closeable closeable : closeables) {
            try {
                closeable.close();
            }
            catch (Throwable e) {
                if (throwable == null) {
                    throwable = e;
                    continue;
                }
                throwable.addSuppressed(e);
            }
        }
        if (throwable != null) {
            Throwables.propagateIfPossible(throwable, IOException.class);
            throw new AssertionError((Object)throwable);
        }
    }

    public static <T> T wrapResource(Callable<T> wrapperFactory, Closeable resource) throws IOException {
        try {
            return wrapperFactory.call();
        }
        catch (Throwable throwable) {
            try {
                resource.close();
            }
            catch (Throwable e1) {
                throwable.addSuppressed(e1);
            }
            Throwables.propagateIfPossible(throwable, IOException.class);
            throw new AssertionError((Object)throwable);
        }
    }
}

