/*
 * Decompiled with CFR 0.152.
 */
package org.iq80.leveldb.table;

import com.google.common.base.Preconditions;
import java.util.Objects;
import org.iq80.leveldb.util.Slice;

final class RestartPositions {
    private final Slice restartPositions;
    private final int size;

    RestartPositions(Slice restartPositions) {
        Objects.requireNonNull(restartPositions, "restartPositions is null");
        Preconditions.checkArgument(restartPositions.length() % 4 == 0, "restartPositions.readableBytes() must be a multiple of %s", 4);
        this.restartPositions = restartPositions;
        this.size = restartPositions.length() / 4;
    }

    public int get(int index) {
        Preconditions.checkPositionIndex(index, this.size, "index out of range");
        return this.restartPositions.getInt(index * 4);
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public int size() {
        return this.size;
    }
}

