/*
 * Decompiled with CFR 0.152.
 */
package org.iq80.leveldb.table;

import java.util.Objects;
import org.iq80.leveldb.DBComparator;
import org.iq80.leveldb.table.UserComparator;
import org.iq80.leveldb.util.Slice;

public class CustomUserComparator
implements UserComparator {
    private final DBComparator comparator;

    public CustomUserComparator(DBComparator comparator) {
        Objects.requireNonNull(comparator.name(), "User Comparator name can't be null");
        this.comparator = comparator;
    }

    @Override
    public String name() {
        return this.comparator.name();
    }

    @Override
    public Slice findShortestSeparator(Slice start, Slice limit) {
        byte[] shortestSeparator = this.comparator.findShortestSeparator(start.getBytes(), limit.getBytes());
        Objects.requireNonNull(shortestSeparator, "User comparator returned null from findShortestSeparator()");
        return new Slice(shortestSeparator);
    }

    @Override
    public Slice findShortSuccessor(Slice key) {
        byte[] shortSuccessor = this.comparator.findShortSuccessor(key.getBytes());
        Objects.requireNonNull(this.comparator, "User comparator returned null from findShortSuccessor()");
        return new Slice(shortSuccessor);
    }

    @Override
    public int compare(Slice o1, Slice o2) {
        return this.comparator.compare(o1.getBytes(), o2.getBytes());
    }
}

