/*
 * Decompiled with CFR 0.152.
 */
package org.iq80.leveldb.memenv;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import org.iq80.leveldb.env.File;
import org.iq80.leveldb.env.RandomInputFile;
import org.iq80.leveldb.memenv.FileState;

class MemRandomInputFile
implements RandomInputFile {
    private final File file;
    private final FileState fileState;
    private boolean closed;

    public MemRandomInputFile(File file, FileState fileState) {
        this.file = file;
        this.fileState = fileState;
        this.closed = false;
    }

    @Override
    public long size() {
        return this.file.length();
    }

    @Override
    public ByteBuffer read(long offset, int length) throws IOException {
        if (this.closed) {
            throw new ClosedChannelException();
        }
        byte[] read = this.fileState.read(offset, length);
        if (read == null) {
            throw new IOException("Could not read all the data");
        }
        return ByteBuffer.wrap(read);
    }

    @Override
    public void close() throws IOException {
        this.closed = true;
    }
}

