/*
 * Decompiled with CFR 0.152.
 */
package org.iq80.leveldb.iterator;

import java.util.Comparator;
import java.util.List;
import java.util.function.Function;
import org.iq80.leveldb.iterator.ASeekingIterator;

class SortedCollectionIterator<T, K, V>
extends ASeekingIterator<K, V> {
    private final List<T> entries;
    private Function<T, K> keyExtractor;
    private Function<T, V> valueExtractor;
    private Comparator<K> comparator;
    private int index;

    SortedCollectionIterator(List<T> entries, Function<T, K> keyExtractor, Function<T, V> valueExtractor, Comparator<K> comparator) {
        this.entries = entries;
        this.keyExtractor = keyExtractor;
        this.valueExtractor = valueExtractor;
        this.comparator = comparator;
        this.index = entries.size();
    }

    @Override
    public void internalClose() {
    }

    @Override
    protected boolean internalSeekToFirst() {
        if (this.entries.isEmpty()) {
            return false;
        }
        this.index = 0;
        return true;
    }

    @Override
    protected boolean internalSeekToLast() {
        if (this.entries.isEmpty()) {
            return false;
        }
        this.index = this.entries.size() - 1;
        return true;
    }

    @Override
    protected boolean internalSeek(K targetKey) {
        if (this.entries.isEmpty()) {
            return false;
        }
        int left = 0;
        int right = this.entries.size() - 1;
        while (left < right) {
            int mid = (left + right) / 2;
            if (this.comparator.compare(this.keyExtractor.apply(this.entries.get(mid)), targetKey) < 0) {
                left = mid + 1;
                continue;
            }
            right = mid;
        }
        this.index = right;
        if (this.index == this.entries.size() - 1 && this.comparator.compare(this.keyExtractor.apply(this.entries.get(this.index)), targetKey) < 0) {
            ++this.index;
        }
        return this.index < this.entries.size();
    }

    @Override
    protected boolean internalNext(boolean switchDirection) {
        ++this.index;
        return this.index < this.entries.size();
    }

    @Override
    protected boolean internalPrev(boolean switchDirection) {
        if (this.index == 0) {
            return false;
        }
        --this.index;
        return true;
    }

    @Override
    protected K internalKey() {
        return this.keyExtractor.apply(this.entries.get(this.index));
    }

    @Override
    protected V internalValue() {
        return this.valueExtractor.apply(this.entries.get(this.index));
    }
}

