/*
 * Decompiled with CFR 0.152.
 */
package org.iq80.leveldb.impl;

import java.io.IOException;
import org.iq80.leveldb.env.Env;
import org.iq80.leveldb.env.File;
import org.iq80.leveldb.env.WritableFile;
import org.iq80.leveldb.impl.LogWriter;
import org.iq80.leveldb.util.PureJavaCrc32C;
import org.iq80.leveldb.util.Slice;

public final class Logs {
    private Logs() {
    }

    public static LogWriter createLogWriter(File file, long fileNumber, Env env) throws IOException {
        return LogWriter.createWriter(fileNumber, env.newWritableFile(file));
    }

    public static LogWriter createLogWriter(long fileNumber, WritableFile writableFile, long destinationLength) throws IOException {
        return LogWriter.createWriter(fileNumber, writableFile, destinationLength);
    }

    public static int getChunkChecksum(int chunkTypeId, Slice slice) {
        return Logs.getChunkChecksum(chunkTypeId, slice.getRawArray(), slice.getRawOffset(), slice.length());
    }

    public static int getChunkChecksum(int chunkTypeId, byte[] buffer, int offset, int length) {
        PureJavaCrc32C crc32C = new PureJavaCrc32C();
        crc32C.update(chunkTypeId);
        crc32C.update(buffer, offset, length);
        return crc32C.getMaskedValue();
    }
}

