/*
 * Decompiled with CFR 0.152.
 */
package org.iq80.leveldb.fileenv;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.ClosedByInterruptException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.FileChannel;
import java.util.Objects;
import org.iq80.leveldb.env.RandomInputFile;

class UnbufferedRandomInputFile
implements RandomInputFile {
    private static final int MAX_RETRY = Integer.getInteger(" org.iq80.leveldb.FileChannel.RETRY", 1000);
    private final Object lock = new Object();
    private final File file;
    private volatile FileChannel fileChannel;
    private final long size;
    private boolean closed = false;

    private UnbufferedRandomInputFile(File file, FileChannel fileChannel, long size) {
        this.file = file;
        this.fileChannel = fileChannel;
        this.size = size;
    }

    public static RandomInputFile open(File file) throws IOException {
        Objects.requireNonNull(file, "file is null");
        FileChannel channel = UnbufferedRandomInputFile.openChannel(file);
        return new UnbufferedRandomInputFile(file, channel, channel.size());
    }

    private static FileChannel openChannel(File file) throws FileNotFoundException {
        return new FileInputStream(file).getChannel();
    }

    @Override
    public long size() {
        return this.size;
    }

    @Override
    public ByteBuffer read(long offset, int length) throws IOException {
        if (Thread.currentThread().isInterrupted()) {
            throw new ClosedByInterruptException();
        }
        ByteBuffer uncompressedBuffer = ByteBuffer.allocate(length).order(ByteOrder.LITTLE_ENDIAN);
        int maxRetry = MAX_RETRY;
        while (true) {
            FileChannel fc = this.fileChannel;
            try {
                fc.read(uncompressedBuffer, offset);
                if (uncompressedBuffer.hasRemaining()) {
                    throw new IOException("Could not read all the data");
                }
                uncompressedBuffer.clear();
                return uncompressedBuffer;
            }
            catch (ClosedByInterruptException e) {
                throw e;
            }
            catch (ClosedChannelException e) {
                uncompressedBuffer.clear();
                if (this.reOpenChannel(fc)) continue;
                throw new IOException("Channel closed by an other thread concurrently");
                if (--maxRetry > 0) continue;
                throw new IOException("Unable to reopen file after close exception");
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean reOpenChannel(FileChannel currentFc) throws FileNotFoundException {
        Object object = this.lock;
        synchronized (object) {
            if (this.closed) {
                return false;
            }
            if (this.fileChannel == currentFc) {
                this.fileChannel = UnbufferedRandomInputFile.openChannel(this.file);
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.closed) {
                return;
            }
            this.closed = true;
        }
        this.fileChannel.close();
    }

    public String toString() {
        return "FileTableDataSource{file='" + String.valueOf(this.file) + "', size=" + this.size + "}";
    }
}

