/*
 * Decompiled with CFR 0.152.
 */
package org.iq80.leveldb.fileenv;

import com.google.common.base.Preconditions;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.List;

public final class FileUtils {
    private static final int TEMP_DIR_ATTEMPTS = 10000;

    private FileUtils() {
    }

    public static boolean isSymbolicLink(File file) {
        try {
            File canonicalFile = file.getCanonicalFile();
            File absoluteFile = file.getAbsoluteFile();
            File parentFile = file.getParentFile();
            return !canonicalFile.getName().equals(absoluteFile.getName()) || parentFile != null && !parentFile.getCanonicalPath().equals(canonicalFile.getParent());
        }
        catch (IOException e) {
            return true;
        }
    }

    public static List<File> listFiles(File dir) {
        File[] files = dir.listFiles();
        if (files == null) {
            return List.of();
        }
        return List.of(files);
    }

    public static List<File> listFiles(File dir, FilenameFilter filter) {
        File[] files = dir.listFiles(filter);
        if (files == null) {
            return List.of();
        }
        return List.of(files);
    }

    public static File createTempDir(String prefix) {
        return FileUtils.createTempDir(new File(System.getProperty("java.io.tmpdir")), prefix);
    }

    public static File createTempDir(File parentDir, String prefix) {
        Object baseName = "";
        if (prefix != null) {
            baseName = (String)baseName + prefix + "-";
        }
        baseName = (String)baseName + System.currentTimeMillis() + "-";
        for (int counter = 0; counter < 10000; ++counter) {
            File tempDir = new File(parentDir, (String)baseName + counter);
            if (!tempDir.mkdir()) continue;
            return tempDir;
        }
        throw new IllegalStateException("Failed to create directory within 10000 attempts (tried " + (String)baseName + "0 to " + (String)baseName + "9999)");
    }

    public static boolean deleteDirectoryContents(File directory) {
        Preconditions.checkArgument(directory.isDirectory(), "Not a directory: %s", (Object)directory);
        if (FileUtils.isSymbolicLink(directory)) {
            return false;
        }
        boolean success = true;
        for (File file : FileUtils.listFiles(directory)) {
            success = FileUtils.deleteRecursively(file) && success;
        }
        return success;
    }

    public static boolean deleteRecursively(File file) {
        boolean success = true;
        if (file.isDirectory()) {
            success = FileUtils.deleteDirectoryContents(file);
        }
        return file.delete() && success;
    }
}

