/*
 * Decompiled with CFR 0.152.
 */
package org.iq80.leveldb.fileenv;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.time.LocalDateTime;
import java.util.function.Supplier;
import org.iq80.leveldb.Logger;
import org.iq80.leveldb.util.LogMessageFormatter;

class FileLogger
implements Logger {
    private final PrintStream ps;
    private final LogMessageFormatter formatter;

    private FileLogger(PrintStream ps, LogMessageFormatter formatter) {
        this.ps = ps;
        this.formatter = formatter;
    }

    public static Logger createLogger(OutputStream outputStream, Supplier<LocalDateTime> clock) {
        return new FileLogger(new PrintStream(outputStream), new LogMessageFormatter(clock));
    }

    public static Logger createFileLogger(File loggerFile) throws IOException {
        return FileLogger.createLogger(new FileOutputStream(loggerFile), LocalDateTime::now);
    }

    @Override
    public void log(String template, Object ... args) {
        this.log2(this.formatter.format(template, args));
    }

    @Override
    public void log(String message) {
        this.log2(this.formatter.format(message));
    }

    private void log2(String message) {
        this.ps.println(message);
    }

    @Override
    public void close() throws IOException {
        this.ps.close();
    }
}

