/*
 * Decompiled with CFR 0.152.
 */
package com.hivemc.chunker.scheduling.task.executor;

import com.google.common.base.Preconditions;
import com.hivemc.chunker.scheduling.task.executor.PriorityRunnable;
import com.hivemc.chunker.scheduling.task.executor.TaskExecutorSupplier;
import java.util.Comparator;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TaskExecutor {
    private static final ThreadLocal<TaskExecutor> EXECUTORS = new InheritableThreadLocal<TaskExecutor>();
    private static final Comparator<PriorityRunnable> COMPARATOR = Comparator.comparing(PriorityRunnable::getPriority).reversed();
    private final PriorityBlockingQueue<PriorityRunnable> tasks = new PriorityBlockingQueue<PriorityRunnable>(100, COMPARATOR);
    private final Thread[] pool;
    private final Consumer<Throwable> exceptionHandler;
    @Nullable
    private final BiConsumer<String, Object> signalConsumer;

    public TaskExecutor(int threads, @Nullable Consumer<Throwable> exceptionHandler, @Nullable BiConsumer<String, Object> signalConsumer) {
        this.pool = new Thread[threads];
        for (int i = 0; i < this.pool.length; ++i) {
            this.pool[i] = new Thread(this::threadLoop, "Task Processor " + i);
            this.pool[i].setUncaughtExceptionHandler(this::handleUncaughtException);
            this.pool[i].start();
        }
        this.exceptionHandler = exceptionHandler;
        this.signalConsumer = signalConsumer;
    }

    protected void handleUncaughtException(Thread thread, Throwable throwable) {
        if (throwable instanceof OutOfMemoryError) {
            try {
                throwable.printStackTrace();
            }
            catch (OutOfMemoryError outOfMemoryError) {
                // empty catch block
            }
            System.exit(12);
        }
        this.handleException(throwable);
    }

    @NotNull
    public static TaskExecutor currentExecutor() {
        TaskExecutor executor = EXECUTORS.get();
        Preconditions.checkNotNull(executor, "There is no current executor, either an Environment hasn't been made or this thread is outside the scope.");
        return executor;
    }

    public void setCurrentThreadExecutor() {
        EXECUTORS.set(this);
    }

    public void clearCurrentThreadExecutor() {
        if (EXECUTORS.get() == this) {
            EXECUTORS.remove();
        }
    }

    public void handleException(@NotNull Throwable throwable) {
        if (this.exceptionHandler != null) {
            this.exceptionHandler.accept(throwable);
        } else {
            throwable.printStackTrace();
        }
    }

    public <T> CompletableFuture<T> execute(Supplier<T> supplier, int priority) {
        CompletableFuture future = new CompletableFuture();
        TaskExecutorSupplier<T> wrapper = new TaskExecutorSupplier<T>(priority, supplier, future);
        this.tasks.add(wrapper);
        return future;
    }

    public void shutdown() {
        for (Thread thread : this.pool) {
            thread.interrupt();
        }
        this.tasks.clear();
    }

    public void signal(String signalName, Object signalValue) {
        if (this.signalConsumer == null) {
            return;
        }
        try {
            this.signalConsumer.accept(signalName, signalValue);
        }
        catch (Throwable t) {
            this.handleException(t);
        }
    }

    protected void threadLoop() {
        this.setCurrentThreadExecutor();
        while (!Thread.currentThread().isInterrupted()) {
            PriorityRunnable task = this.tasks.poll();
            if (task == null) continue;
            task.run();
        }
        this.clearCurrentThreadExecutor();
    }
}

