/*
 * Decompiled with CFR 0.152.
 */
package com.hivemc.chunker.scheduling.task;

import com.hivemc.chunker.scheduling.task.ProgressiveTask;
import com.hivemc.chunker.scheduling.task.Task;
import com.hivemc.chunker.scheduling.task.TaskWeight;
import com.hivemc.chunker.util.SneakyThrows;
import java.util.LinkedList;
import java.util.List;
import java.util.Stack;
import java.util.concurrent.CompletableFuture;

public abstract class TrackedTask<O>
implements ProgressiveTask<O> {
    private static final ThreadLocal<Stack<TrackedTask<?>>> currentTaskStack = ThreadLocal.withInitial(Stack::new);
    private final String name;
    private final int weight;
    private Task.TaskStatus status;
    private List<ProgressiveTask<?>> children;
    private int depth;

    public TrackedTask(String name, TaskWeight weight) {
        this.name = name;
        this.weight = weight.getWeight();
        this.status = Task.TaskStatus.PENDING;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void start() {
        TrackedTask trackedTask = this;
        synchronized (trackedTask) {
            if (this.status != Task.TaskStatus.PENDING) {
                throw new IllegalArgumentException("Unable to start task which has already been started!");
            }
            currentTaskStack.get().push(this);
            this.status = Task.TaskStatus.STARTED;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setupParent() {
        TrackedTask<?> parentTask = currentTaskStack.get().peek();
        if (parentTask == null) {
            throw new RuntimeException("Tried to launch a task without a parent, was this called from a thread outside the task system? Wrap your stuff in try(Task.environment()){}!");
        }
        TrackedTask<?> trackedTask = parentTask;
        synchronized (trackedTask) {
            if (parentTask.status == Task.TaskStatus.DONE) {
                throw new RuntimeException("Tried to launch a task after the parent completed, this shouldn't be possible.");
            }
            if (parentTask.children == null) {
                parentTask.children = new LinkedList();
            }
            parentTask.children.add(this);
        }
        this.depth = parentTask.getDepth() + 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void free() {
        TrackedTask trackedTask = this;
        synchronized (trackedTask) {
            if (this.status == Task.TaskStatus.PENDING) {
                throw new IllegalArgumentException("Unable to free task which has not started");
            }
            if (this.status == Task.TaskStatus.DONE) {
                throw new IllegalArgumentException("Unable to free task which has already been freed!");
            }
            this.status = Task.TaskStatus.DONE;
            this.children = null;
        }
    }

    protected O onSelfComplete(O result) {
        if (currentTaskStack.get().pop() != this) {
            throw new IllegalArgumentException("This task did not remove itself? Something went wrong in handling completion");
        }
        return result;
    }

    protected void onSelfFail(Throwable ex) {
        if (currentTaskStack.get().pop() != this) {
            throw new IllegalArgumentException("This task did not remove itself? Something went wrong in handling completion");
        }
        SneakyThrows.throwException(ex);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected CompletableFuture<O> waitForChildren(O result) {
        TrackedTask trackedTask = this;
        synchronized (trackedTask) {
            if (this.status == Task.TaskStatus.DONE) {
                return CompletableFuture.completedFuture(result);
            }
            if (this.children == null || this.children.isEmpty()) {
                return CompletableFuture.completedFuture(result);
            }
            return Task.join(this.children).then((List<?>)result).future();
        }
    }

    @Override
    public double getProgress() {
        TrackedTask trackedTask = this;
        synchronized (trackedTask) {
            if (this.status == Task.TaskStatus.PENDING) {
                return 0.0;
            }
            if (this.status == Task.TaskStatus.STARTED) {
                if (this.children != null) {
                    int totalWeight = this.getSelfWeight();
                    double weightedProgressTotal = 0.0;
                    for (ProgressiveTask<?> task : this.children) {
                        weightedProgressTotal += task.getProgress() * (double)task.getWeight();
                        totalWeight += task.getWeight();
                    }
                    return totalWeight == 0 ? 0.0 : weightedProgressTotal / (double)totalWeight;
                }
                return 0.0;
            }
            if (this.status == Task.TaskStatus.DONE) {
                return 1.0;
            }
            throw new IllegalArgumentException("Unknown TaskStatus");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getDetailedProgress() {
        TrackedTask trackedTask = this;
        synchronized (trackedTask) {
            String padding = "-".repeat(this.getDepth());
            Object details = padding + " " + this.getName() + " - " + String.format("%.2f%%", this.getProgress() * 100.0) + " - Weight: " + this.getWeight() + "\n";
            if (this.children != null) {
                for (ProgressiveTask<?> task : this.children) {
                    details = ((String)details).concat(task.getDetailedProgress());
                }
            }
            return details;
        }
    }

    public String getName() {
        return this.name;
    }

    public int getDepth() {
        return this.depth;
    }

    @Override
    public int getWeight() {
        return this.weight;
    }
}

