/*
 * Decompiled with CFR 0.152.
 */
package com.hivemc.chunker.scheduling.task;

import com.google.common.base.Preconditions;
import com.hivemc.chunker.scheduling.task.TaskWeight;
import com.hivemc.chunker.scheduling.task.TrackedTask;
import com.hivemc.chunker.scheduling.task.executor.TaskExecutor;
import com.hivemc.chunker.util.SneakyThrows;
import java.io.Closeable;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.jetbrains.annotations.Nullable;

public class Environment
extends TrackedTask<Void>
implements Closeable {
    private final TaskExecutor executor;
    private CompletableFuture<Void> childFuture;
    private CompletableFuture<Void> future;
    private Runnable onFree;

    public Environment(String name, int threads, Consumer<Throwable> exceptionHandler, @Nullable BiConsumer<String, Object> signalConsumer) {
        super(name, TaskWeight.NONE);
        this.executor = new TaskExecutor(threads, exceptionHandler, signalConsumer);
    }

    @Override
    protected void start() {
        super.start();
        this.executor.setCurrentThreadExecutor();
    }

    @Override
    public void close() {
        this.childFuture = this.waitForChildren(null).toCompletableFuture();
        this.executor.clearCurrentThreadExecutor();
        this.future = this.childFuture.handle((input, throwable) -> {
            this.free();
            if (throwable != null) {
                SneakyThrows.throwException(throwable);
            }
            return input;
        });
    }

    @Override
    public int getWeight() {
        return 0;
    }

    public void cancel(@Nullable Throwable exception) {
        try {
            this.executor.shutdown();
        }
        finally {
            if (exception != null) {
                this.childFuture.completeExceptionally(exception);
            } else {
                this.childFuture.cancel(true);
            }
        }
    }

    @Override
    public CompletableFuture<Void> future() {
        Preconditions.checkNotNull(this.future, "It is not possible to wait for an environment which tasks can still be queued, please call after .close()!");
        return this.future;
    }

    @Override
    protected void free() {
        if (this.onFree != null) {
            this.onFree.run();
        }
        super.free();
        this.executor.shutdown();
    }

    public void setFreeCallback(@Nullable Runnable onFree) {
        this.onFree = onFree;
    }
}

