/*
 * Decompiled with CFR 0.152.
 */
package com.hivemc.chunker.resolver.property;

import com.hivemc.chunker.resolver.property.Property;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.Nullable;

public class PropertyHolder<H extends PropertyHolder<?>> {
    protected final Map<Property<? super H, ?>, Object> properties;

    public PropertyHolder(Map<Property<? super H, ?>, Object> properties) {
        this.properties = properties;
    }

    public PropertyHolder() {
        this(new Object2ObjectOpenHashMap());
    }

    public <P extends Property<? super H, ? super V>, V> V get(P property, V defaultValue) {
        Object value = this.properties.get(property);
        return (V)(value == null ? defaultValue : value);
    }

    @Nullable
    public <P extends Property<? super H, ? super V>, V> V get(P property) {
        return this.get(property, null);
    }

    @Nullable
    public <P extends Property<? super H, ? super V>, V> V put(P property, V value) {
        return (V)this.properties.put(property, value);
    }

    @Nullable
    public <P extends Property<? super H, ? super V>, V> V remove(P property) {
        return (V)this.properties.remove(property);
    }

    public Map<Property<? super H, ?>, Object> getProperties() {
        return this.properties;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PropertyHolder)) {
            return false;
        }
        PropertyHolder that = (PropertyHolder)o;
        return Objects.equals(this.properties, that.properties);
    }

    public int hashCode() {
        return Objects.hash(this.properties);
    }

    public String toString() {
        return "PropertyHolder{properties=" + String.valueOf(this.properties) + "}";
    }
}

