/*
 * Decompiled with CFR 0.152.
 */
package com.hivemc.chunker.resolver.property;

import com.hivemc.chunker.resolver.Resolver;
import com.hivemc.chunker.resolver.property.Property;
import com.hivemc.chunker.resolver.property.PropertyHandler;
import com.hivemc.chunker.resolver.property.PropertyHolder;
import it.unimi.dsi.fastutil.Pair;
import it.unimi.dsi.fastutil.objects.ObjectObjectMutablePair;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.jetbrains.annotations.Nullable;

public abstract class PropertyBasedResolver<R, S, H extends PropertyHolder<? extends H>>
implements Resolver<S, H> {
    private final Map<Property<H, ?>, HandlerWrapper<H, S>> propertyHandlers = new LinkedHashMap();
    protected final R resolvers;

    public PropertyBasedResolver(R resolvers) {
        this.resolvers = resolvers;
        this.registerHandlers(resolvers);
    }

    @Override
    public Optional<H> to(S input) {
        Optional<H> optionalHolder = this.createPropertyHolder(input);
        if (optionalHolder.isPresent()) {
            HandlerWrapper<PropertyHolder, S> propertyHandlerWrapper;
            PropertyHolder holder = (PropertyHolder)optionalHolder.get();
            Iterator<HandlerWrapper<H, S>> iterator = this.propertyHandlers.values().iterator();
            while (iterator.hasNext() && (holder = (propertyHandlerWrapper = iterator.next()).readProperty(input, holder)) != null) {
            }
            return Optional.ofNullable(holder);
        }
        return optionalHolder;
    }

    @Override
    public Optional<S> from(H input) {
        Optional<S> optionalOutput = this.createOutput(input);
        if (optionalOutput.isPresent()) {
            HandlerWrapper<H, S> propertyHandlerWrapper;
            S output = optionalOutput.get();
            Iterator<HandlerWrapper<H, S>> iterator = this.propertyHandlers.values().iterator();
            while (iterator.hasNext() && (output = (propertyHandlerWrapper = iterator.next()).writeProperty(input, output)) != null) {
            }
            return Optional.ofNullable(output);
        }
        return optionalOutput;
    }

    protected <V> void registerHandler(Property<H, ? super V> property, PropertyHandler<S, V> handler) {
        this.propertyHandlers.put(property, new PropertyHandlerWrapper<H, S, V>(property, handler));
    }

    protected <V> void registerContextualHandler(Property<H, ? super V> property, PropertyHandler<Pair<H, S>, V> handler) {
        this.propertyHandlers.put(property, new ContextualHandlerWrapper<H, S, V>(property, handler));
    }

    public Set<Property<H, ?>> getSupportedProperties() {
        return this.propertyHandlers.keySet();
    }

    protected abstract void registerHandlers(R var1);

    protected abstract Optional<H> createPropertyHolder(S var1);

    protected abstract Optional<S> createOutput(H var1);

    static interface HandlerWrapper<H extends PropertyHolder<? extends H>, S> {
        @Nullable
        public H readProperty(S var1, H var2);

        @Nullable
        public S writeProperty(H var1, S var2);
    }

    record PropertyHandlerWrapper<H extends PropertyHolder<? extends H>, S, V>(Property<? super H, ? super V> property, PropertyHandler<S, V> handler) implements HandlerWrapper<H, S>
    {
        @Override
        public H readProperty(S input, H holder) {
            Optional<V> value = this.handler().read(input);
            value.ifPresent(v -> holder.put(this.property, v));
            return holder;
        }

        @Override
        public S writeProperty(H holder, S output) {
            Object value = ((PropertyHolder)holder).get(this.property());
            if (value == null) {
                value = this.handler.getDefaultValue(output);
            }
            if (value != null) {
                this.handler().write(output, value);
            }
            return output;
        }
    }

    record ContextualHandlerWrapper<H extends PropertyHolder<? extends H>, S, V>(Property<? super H, ? super V> property, PropertyHandler<Pair<H, S>, V> handler) implements HandlerWrapper<H, S>
    {
        @Override
        public H readProperty(S input, H holder) {
            ObjectObjectMutablePair<H, S> state = new ObjectObjectMutablePair<H, S>(holder, input);
            Optional<V> value = this.handler().read(state);
            if (state.left() != null) {
                value.ifPresent(v -> ((PropertyHolder)state.left()).put(this.property, v));
            }
            return (H)((PropertyHolder)state.left());
        }

        @Override
        public S writeProperty(H holder, S output) {
            ObjectObjectMutablePair<H, S> state = new ObjectObjectMutablePair<H, S>(holder, output);
            Object value = ((PropertyHolder)holder).get(this.property());
            if (value == null) {
                value = this.handler.getDefaultValue(state);
            }
            if (value != null && state.right() != null) {
                this.handler().write(state, value);
            }
            return (S)state.right();
        }
    }
}

