/*
 * Decompiled with CFR 0.152.
 */
package com.hivemc.chunker.resolver.hierarchy;

import com.hivemc.chunker.conversion.encoding.base.Version;
import com.hivemc.chunker.resolver.Resolver;
import com.hivemc.chunker.resolver.hierarchy.TypeHandler;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.Nullable;

public abstract class KeyedHierarchyBasedResolver<R, K, D, T>
implements Resolver<D, T> {
    protected final R resolvers;
    protected final Version version;
    protected final Map<K, TypeHandler<R, K, D, ? extends T>> keyLookup = new ConcurrentHashMap<K, TypeHandler<R, K, D, ? extends T>>();
    protected final Map<Class<?>, TypeHandler<R, K, D, ? extends T>> classHandlerLookup = new ConcurrentHashMap();
    protected final Map<TypeHandler<R, K, D, ? extends T>, Collection<TypeHandler<R, K, D, ? extends T>>> classHierarchyLookupCache = new ConcurrentHashMap<TypeHandler<R, K, D, ? extends T>, Collection<TypeHandler<R, K, D, ? extends T>>>();

    public KeyedHierarchyBasedResolver(Version version, R resolvers) {
        this.resolvers = resolvers;
        this.version = version;
        this.init();
        this.registerTypeHandlers(version);
    }

    protected abstract void init();

    protected Optional<TypeHandler<R, K, D, ? extends T>> getToTypeHandler(D input) {
        return this.getKey(input).map(this.keyLookup::get);
    }

    protected Optional<TypeHandler<R, K, D, ? extends T>> getFromTypeHandler(T input) {
        return Optional.ofNullable(this.classHandlerLookup.get(input.getClass()));
    }

    protected <U extends T> Optional<TypeHandler<R, K, D, U>> getFromClassTypeHandler(Class<U> input) {
        return Optional.ofNullable(this.classHandlerLookup.get(input));
    }

    @Nullable
    protected abstract D constructDataType(K var1);

    protected abstract void registerTypeHandlers(Version var1);

    protected void register(TypeHandler<R, K, D, ? extends T> typeHandler) {
        this.classHandlerLookup.put(typeHandler.getHandledClass(), typeHandler);
        if (typeHandler.getKey() != null) {
            this.keyLookup.put(typeHandler.getKey(), typeHandler);
        }
        this.classHierarchyLookupCache.clear();
    }

    private Collection<TypeHandler<R, K, D, ? extends T>> generateTypeHandlerHierarchy(TypeHandler<R, K, D, ? extends T> lastHandler) {
        ArrayList<TypeHandler<R, K, D, T>> typeHandlers = new ArrayList<TypeHandler<R, K, D, T>>(1);
        typeHandlers.add(lastHandler);
        Class<T> parent = lastHandler.getHandledClass();
        while (parent != null && parent != Object.class) {
            TypeHandler<R, K, D, ? extends T> typeHandler = this.classHandlerLookup.get(parent = parent.getSuperclass());
            if (typeHandler == null) continue;
            typeHandlers.add(typeHandler);
        }
        Collections.reverse(typeHandlers);
        return typeHandlers;
    }

    protected Collection<TypeHandler<R, K, D, ? extends T>> getTypeHandlers(TypeHandler<R, K, D, ? extends T> lastHandler) {
        return this.classHierarchyLookupCache.computeIfAbsent(lastHandler, this::generateTypeHandlerHierarchy);
    }

    public abstract Optional<K> getKey(D var1);

    @Override
    public Optional<T> to(D input) {
        Optional<TypeHandler<R, K, D, T>> optionalTypeHandler = this.getToTypeHandler(input);
        if (optionalTypeHandler.isEmpty()) {
            return Optional.empty();
        }
        TypeHandler<R, K, D, T> lastTypeHandler = optionalTypeHandler.get();
        T output = lastTypeHandler.construct();
        if (output == null) {
            return Optional.empty();
        }
        Collection<TypeHandler<R, K, D, T>> typeHandlers = this.getTypeHandlers(lastTypeHandler);
        for (TypeHandler<R, K, D, T> typeHandler : typeHandlers) {
            typeHandler.read(this.resolvers, input, output);
        }
        return Optional.of(output);
    }

    public Optional<T> to(Class<? extends T> type, D input) {
        Optional<TypeHandler<R, K, D, T>> optionalTypeHandler = this.getFromClassTypeHandler(type);
        if (optionalTypeHandler.isEmpty()) {
            return Optional.empty();
        }
        TypeHandler<R, K, D, T> lastTypeHandler = optionalTypeHandler.get();
        if (!type.isAssignableFrom(lastTypeHandler.getHandledClass())) {
            return Optional.empty();
        }
        T output = lastTypeHandler.construct();
        if (output == null) {
            return Optional.empty();
        }
        Collection<TypeHandler<R, K, D, T>> typeHandlers = this.getTypeHandlers(lastTypeHandler);
        for (TypeHandler<R, K, D, T> typeHandler : typeHandlers) {
            typeHandler.read(this.resolvers, input, output);
        }
        return Optional.of(output);
    }

    @Override
    public Optional<D> from(T input) {
        Optional<TypeHandler<R, K, D, T>> optionalTypeHandler = this.getFromTypeHandler(input);
        if (optionalTypeHandler.isEmpty()) {
            return Optional.empty();
        }
        TypeHandler<R, K, D, T> lastTypeHandler = optionalTypeHandler.get();
        if (!lastTypeHandler.getHandledClass().isInstance(input)) {
            return Optional.empty();
        }
        D output = this.constructDataType(lastTypeHandler.getKey());
        if (output == null) {
            return Optional.empty();
        }
        Collection<TypeHandler<R, K, D, T>> typeHandlers = this.getTypeHandlers(lastTypeHandler);
        for (TypeHandler<R, K, D, T> typeHandler : typeHandlers) {
            typeHandler.write(this.resolvers, output, input);
        }
        return Optional.of(output);
    }
}

