/*
 * Decompiled with CFR 0.152.
 */
package com.hivemc.chunker.resolver;

import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import java.util.Optional;

public interface Resolver<T, U> {
    public Optional<U> to(T var1);

    public Optional<T> from(U var1);

    default public <V> Resolver<T, V> then(Resolver<U, V> chained) {
        return new ChainedResolver(this, chained);
    }

    default public Resolver<U, T> inverse() {
        return new InversedResolver(this);
    }

    default public Resolver<T, U> cached() {
        final Resolver original = this;
        return new Resolver<T, U>(){
            private final LoadingCache<T, Optional<U>> toCache = Caffeine.newBuilder().build(original::to);
            private final LoadingCache<U, Optional<T>> fromCache = Caffeine.newBuilder().build(original::from);

            @Override
            public Optional<U> to(T input) {
                return this.toCache.get(input);
            }

            @Override
            public Optional<T> from(U input) {
                return this.fromCache.get(input);
            }
        };
    }

    public static class ChainedResolver<T, U, V>
    implements Resolver<T, V> {
        private final Resolver<T, U> original;
        private final Resolver<U, V> chained;

        private ChainedResolver(Resolver<T, U> original, Resolver<U, V> chained) {
            this.original = original;
            this.chained = chained;
        }

        @Override
        public Optional<V> to(T input) {
            return this.original.to(input).flatMap(this.chained::to);
        }

        @Override
        public Optional<T> from(V input) {
            return this.chained.from(input).flatMap(this.original::from);
        }
    }

    public static class InversedResolver<T, U>
    implements Resolver<T, U> {
        private final Resolver<U, T> original;

        private InversedResolver(Resolver<U, T> original) {
            this.original = original;
        }

        @Override
        public Optional<U> to(T input) {
            return this.original.from(input);
        }

        @Override
        public Optional<T> from(U input) {
            return this.original.to(input);
        }
    }
}

