/*
 * Decompiled with CFR 0.152.
 */
package com.hivemc.chunker.nbt.tags.primitive;

import com.hivemc.chunker.nbt.TagType;
import com.hivemc.chunker.nbt.io.Reader;
import com.hivemc.chunker.nbt.io.Writer;
import com.hivemc.chunker.nbt.tags.Tag;
import java.io.IOException;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public class LongTag
extends Tag<Long> {
    protected long value;

    public LongTag(long value) {
        this.value = value;
    }

    public LongTag() {
    }

    @Override
    @NotNull
    public TagType<LongTag, Long> getType() {
        return TagType.LONG;
    }

    @Override
    public boolean valueEquals(Tag<Long> tag) {
        return Objects.equals(this.value, ((LongTag)tag).getValue());
    }

    @Override
    public Long getBoxedValue() {
        return this.value;
    }

    @Override
    public LongTag clone() {
        return new LongTag(this.value);
    }

    @Override
    public void encodeValue(Writer writer) throws IOException {
        writer.writeLong(this.value);
    }

    @Override
    public void decodeValue(Reader reader) throws IOException {
        this.value = reader.readLong();
    }

    @Override
    public String toSNBT() {
        return this.value + "l";
    }

    public long getValue() {
        return this.value;
    }

    public void setValue(long value) {
        this.value = value;
    }
}

