/*
 * Decompiled with CFR 0.152.
 */
package com.hivemc.chunker.nbt.tags.primitive;

import com.hivemc.chunker.nbt.TagType;
import com.hivemc.chunker.nbt.io.Reader;
import com.hivemc.chunker.nbt.io.Writer;
import com.hivemc.chunker.nbt.tags.Tag;
import java.io.IOException;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public class ByteTag
extends Tag<Byte> {
    protected byte value;

    public ByteTag(byte value) {
        this.value = value;
    }

    public ByteTag() {
    }

    @Override
    @NotNull
    public TagType<ByteTag, Byte> getType() {
        return TagType.BYTE;
    }

    @Override
    public boolean valueEquals(Tag<Byte> tag) {
        return Objects.equals(this.value, ((ByteTag)tag).getValue());
    }

    @Override
    public Byte getBoxedValue() {
        return this.value;
    }

    @Override
    public ByteTag clone() {
        return new ByteTag(this.value);
    }

    @Override
    public void encodeValue(Writer writer) throws IOException {
        writer.writeByte(this.value);
    }

    @Override
    public void decodeValue(Reader reader) throws IOException {
        this.value = reader.readByte();
    }

    @Override
    public String toSNBT() {
        return this.value + "b";
    }

    public byte getValue() {
        return this.value;
    }

    public void setValue(byte value) {
        this.value = value;
    }
}

