/*
 * Decompiled with CFR 0.152.
 */
package com.hivemc.chunker.nbt.tags.collection;

import com.hivemc.chunker.nbt.TagType;
import com.hivemc.chunker.nbt.io.Reader;
import com.hivemc.chunker.nbt.io.Writer;
import com.hivemc.chunker.nbt.tags.Tag;
import com.hivemc.chunker.nbt.tags.array.ByteArrayTag;
import com.hivemc.chunker.nbt.tags.array.IntArrayTag;
import com.hivemc.chunker.nbt.tags.array.LongArrayTag;
import com.hivemc.chunker.nbt.tags.collection.ListTag;
import com.hivemc.chunker.nbt.tags.primitive.ByteTag;
import com.hivemc.chunker.nbt.tags.primitive.DoubleTag;
import com.hivemc.chunker.nbt.tags.primitive.FloatTag;
import com.hivemc.chunker.nbt.tags.primitive.IntTag;
import com.hivemc.chunker.nbt.tags.primitive.LongTag;
import com.hivemc.chunker.nbt.tags.primitive.ShortTag;
import com.hivemc.chunker.nbt.tags.primitive.StringTag;
import it.unimi.dsi.fastutil.objects.Object2ObjectLinkedOpenHashMap;
import java.io.IOException;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.StringJoiner;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CompoundTag
extends Tag<Map<String, Tag<?>>>
implements Iterable<Map.Entry<String, Tag<?>>> {
    public static final int MAX_COMPOUND_LENGTH = 0x100000;
    public static final int MAX_NAME_LENGTH = 256;
    @Nullable
    protected Map<String, Tag<?>> value;

    public CompoundTag(@Nullable Map<String, Tag<?>> value) {
        this.value = value;
    }

    public CompoundTag(int initialCapacity) {
        this(new Object2ObjectLinkedOpenHashMap(initialCapacity));
    }

    public CompoundTag() {
        this(null);
    }

    @Override
    @NotNull
    public TagType<CompoundTag, Map<String, Tag<?>>> getType() {
        return TagType.COMPOUND;
    }

    @Override
    public boolean valueEquals(Map<String, Tag<?>> boxedValue) {
        return Objects.equals(this.value, boxedValue) || this.value == null && boxedValue.isEmpty() || boxedValue == null && this.value.isEmpty();
    }

    @Override
    public boolean valueEquals(Tag<Map<String, Tag<?>>> tag) {
        return this.valueEquals(((CompoundTag)tag).getValue());
    }

    @Override
    public Map<String, Tag<?>> getBoxedValue() {
        return this.getValue();
    }

    @Override
    public CompoundTag clone() {
        if (this.value != null) {
            Object2ObjectLinkedOpenHashMap copy = new Object2ObjectLinkedOpenHashMap(this.value.size());
            for (Map.Entry<String, Tag<?>> namedPair : this.value.entrySet()) {
                copy.put(namedPair.getKey(), (Tag<?>)namedPair.getValue().clone());
            }
            return new CompoundTag(copy);
        }
        return new CompoundTag();
    }

    @Override
    public void encodeValue(Writer writer) throws IOException {
        if (this.value != null) {
            for (Map.Entry<String, Tag<?>> namedPair : this.value.entrySet()) {
                Tag.encodeNamed(writer, namedPair.getKey(), namedPair.getValue());
            }
        }
        Tag.encode(writer, null);
    }

    @Override
    public void decodeValue(Reader reader) throws IOException {
        Tag<?> lastTag;
        this.value = new Object2ObjectLinkedOpenHashMap(8);
        do {
            if ((lastTag = Tag.decodeTagClass(reader)) == null) continue;
            String name = reader.readString(256);
            lastTag.decodeValue(reader);
            this.value.put(name, lastTag);
            if (this.value.size() <= 0x100000) continue;
            throw new IllegalArgumentException("Could not read array with length above " + this.value.size() + " for " + name);
        } while (lastTag != null);
    }

    @Override
    public String toSNBT() {
        StringJoiner joiner = new StringJoiner(",", "{", "}");
        if (this.value != null) {
            for (Map.Entry<String, Tag<?>> namedPair : this.value.entrySet()) {
                String escaped = StringTag.SNBT_ESCAPER.escape(namedPair.getKey());
                if (!escaped.equals(namedPair.getKey())) {
                    escaped = String.format("\"%s\"", escaped);
                }
                joiner.add(escaped + ":" + namedPair.getValue().toSNBT());
            }
        }
        return joiner.toString();
    }

    public Tag<?> put(@NotNull String name, @NotNull Tag<?> tag) {
        if (this.value == null) {
            this.value = new Object2ObjectLinkedOpenHashMap(1);
        }
        return this.value.put(name, tag);
    }

    public Tag<?> put(@NotNull String name, byte value) {
        return this.put(name, new ByteTag(value));
    }

    public Tag<?> put(@NotNull String name, double value) {
        return this.put(name, new DoubleTag(value));
    }

    public Tag<?> put(@NotNull String name, float value) {
        return this.put(name, new FloatTag(value));
    }

    public Tag<?> put(@NotNull String name, int value) {
        return this.put(name, new IntTag(value));
    }

    public Tag<?> put(@NotNull String name, long value) {
        return this.put(name, new LongTag(value));
    }

    public Tag<?> put(@NotNull String name, short value) {
        return this.put(name, new ShortTag(value));
    }

    public Tag<?> put(@NotNull String name, @NotNull String value) {
        return this.put(name, new StringTag(value));
    }

    public Tag<?> put(@NotNull String name, byte @NotNull [] value) {
        return this.put(name, new ByteArrayTag(value));
    }

    public Tag<?> put(@NotNull String name, int @NotNull [] value) {
        return this.put(name, new IntArrayTag(value));
    }

    public Tag<?> put(@NotNull String name, long @NotNull [] value) {
        return this.put(name, new LongArrayTag(value));
    }

    public boolean contains(String name) {
        if (this.value == null) {
            return false;
        }
        return this.value.containsKey(name);
    }

    public Tag<?> remove(String name) {
        if (this.value == null) {
            return null;
        }
        return this.value.remove(name);
    }

    @Nullable
    public <T extends Tag<?>> T get(String name) {
        return (T)this.get(name, Tag.class);
    }

    @Nullable
    public <T extends Tag<?>> T get(String name, Class<T> clazz) {
        if (this.value == null) {
            return null;
        }
        Tag<?> tag = this.value.get(name);
        return (T)((Tag)clazz.cast(tag));
    }

    public <T extends Tag<?>> Optional<T> getOptional(String name, Class<T> classTag) {
        T tag = this.get(name);
        if (tag == null) {
            return Optional.empty();
        }
        return Optional.of((Tag)classTag.cast(tag));
    }

    public <T extends Tag<V>, V> Optional<ListTag<T, V>> getOptionalList(String name, Class<T> listTagType) {
        ListTag<T, V> tag = this.getList(name, listTagType, null);
        return Optional.ofNullable(tag);
    }

    public <V> Optional<V> getOptionalValue(String name, Class<V> classValue) {
        Object tag = this.get(name);
        if (tag == null) {
            return Optional.empty();
        }
        return Optional.of(classValue.cast(((Tag)tag).getBoxedValue()));
    }

    public byte getByte(String name) {
        ByteTag tag = this.get(name, ByteTag.class);
        if (tag == null) {
            throw new IllegalArgumentException("Could not access " + name);
        }
        return tag.getValue();
    }

    public byte getByte(String name, byte defaultValue) {
        ByteTag tag = this.get(name, ByteTag.class);
        if (tag == null) {
            return defaultValue;
        }
        return tag.getValue();
    }

    public double getDouble(String name) {
        DoubleTag tag = this.get(name, DoubleTag.class);
        if (tag == null) {
            throw new IllegalArgumentException("Could not access " + name);
        }
        return tag.getValue();
    }

    public double getDouble(String name, double defaultValue) {
        DoubleTag tag = this.get(name, DoubleTag.class);
        if (tag == null) {
            return defaultValue;
        }
        return tag.getValue();
    }

    public float getFloat(String name) {
        FloatTag tag = this.get(name, FloatTag.class);
        if (tag == null) {
            throw new IllegalArgumentException("Could not access " + name);
        }
        return tag.getValue();
    }

    public float getFloat(String name, float defaultValue) {
        FloatTag tag = this.get(name, FloatTag.class);
        if (tag == null) {
            return defaultValue;
        }
        return tag.getValue();
    }

    public int getInt(String name) {
        IntTag tag = this.get(name, IntTag.class);
        if (tag == null) {
            throw new IllegalArgumentException("Could not access " + name);
        }
        return tag.getValue();
    }

    public int getInt(String name, int defaultValue) {
        IntTag tag = this.get(name, IntTag.class);
        if (tag == null) {
            return defaultValue;
        }
        return tag.getValue();
    }

    public long getLong(String name) {
        LongTag tag = this.get(name, LongTag.class);
        if (tag == null) {
            throw new IllegalArgumentException("Could not access " + name);
        }
        return tag.getValue();
    }

    public long getLong(String name, long defaultValue) {
        LongTag tag = this.get(name, LongTag.class);
        if (tag == null) {
            return defaultValue;
        }
        return tag.getValue();
    }

    public short getShort(String name) {
        ShortTag tag = this.get(name, ShortTag.class);
        if (tag == null) {
            throw new IllegalArgumentException("Could not access " + name);
        }
        return tag.getValue();
    }

    public short getShort(String name, short defaultValue) {
        ShortTag tag = this.get(name, ShortTag.class);
        if (tag == null) {
            return defaultValue;
        }
        return tag.getValue();
    }

    public String getString(String name) {
        StringTag tag = this.get(name, StringTag.class);
        if (tag == null) {
            throw new IllegalArgumentException("Could not access " + name);
        }
        return tag.getValue();
    }

    public String getString(String name, String defaultValue) {
        StringTag tag = this.get(name, StringTag.class);
        if (tag == null) {
            return defaultValue;
        }
        return tag.getValue();
    }

    public byte[] getByteArray(String name) {
        ByteArrayTag tag = this.get(name, ByteArrayTag.class);
        if (tag == null) {
            throw new IllegalArgumentException("Could not access " + name);
        }
        return tag.getValue();
    }

    public byte[] getByteArray(String name, byte[] defaultValue) {
        ByteArrayTag tag = this.get(name, ByteArrayTag.class);
        if (tag == null) {
            return defaultValue;
        }
        return tag.getValue();
    }

    public int[] getIntArray(String name) {
        IntArrayTag tag = this.get(name, IntArrayTag.class);
        if (tag == null) {
            throw new IllegalArgumentException("Could not access " + name);
        }
        return tag.getValue();
    }

    public int[] getIntArray(String name, int[] defaultValue) {
        IntArrayTag tag = this.get(name, IntArrayTag.class);
        if (tag == null) {
            return defaultValue;
        }
        return tag.getValue();
    }

    public long[] getLongArray(String name) {
        LongArrayTag tag = this.get(name, LongArrayTag.class);
        if (tag == null) {
            throw new IllegalArgumentException("Could not access " + name);
        }
        return tag.getValue();
    }

    public long[] getLongArray(String name, long[] defaultValue) {
        LongArrayTag tag = this.get(name, LongArrayTag.class);
        if (tag == null) {
            return defaultValue;
        }
        return tag.getValue();
    }

    public <T extends Tag<V>, V> ListTag<T, V> getList(String name, Class<T> listTagType) {
        ListTag listTag = this.get(name, ListTag.class);
        if (listTag == null) {
            throw new IllegalArgumentException("Could not access " + name);
        }
        if (listTag.getListType() != TagType.END && listTag.getListType() != null && !Objects.equals(listTag.getListType().getTagClass(), listTagType)) {
            throw new IllegalArgumentException("Unexpected list type for " + name + " expected " + String.valueOf(listTagType) + " got " + String.valueOf(listTag.getListType().getTagClass()));
        }
        return listTag;
    }

    public <T extends Tag<V>, V> ListTag<T, V> getList(String name, Class<T> listTagType, ListTag<T, V> defaultValue) {
        Tag tag = this.get(name, Tag.class);
        if (!(tag instanceof ListTag)) {
            LongArrayTag longArrayTag;
            if (tag == null || tag instanceof LongArrayTag && (longArrayTag = (LongArrayTag)tag).length() == 0) {
                return defaultValue;
            }
            throw new IllegalArgumentException("Unexpected tag type " + String.valueOf(tag) + ", expected ListTag.");
        }
        ListTag listTag = (ListTag)tag;
        if (listTag.getListType() != TagType.END && listTag.getListType() != null && !Objects.equals(listTag.getListType().getTagClass(), listTagType)) {
            throw new IllegalArgumentException("Unexpected list type for " + name + " expected " + String.valueOf(listTagType) + " got " + String.valueOf(listTag.getListType().getTagClass()));
        }
        return listTag;
    }

    public <T extends Tag<V>, V> List<V> getListValues(String name, Class<T> listTagType) {
        return this.getList(name, listTagType).toList();
    }

    public <T extends Tag<V>, V> List<V> getListValues(String name, Class<T> listTagType, List<V> defaultValue) {
        ListTag<T, V> listTag = this.getList(name, listTagType, null);
        if (listTag == null) {
            return defaultValue;
        }
        return listTag.toList();
    }

    @Nullable
    public CompoundTag getCompound(String name) {
        return this.get(name, CompoundTag.class);
    }

    public CompoundTag getCompound(String name, CompoundTag defaultValue) {
        CompoundTag value = this.getCompound(name);
        if (value == null) {
            return defaultValue;
        }
        return value;
    }

    public CompoundTag getOrCreateCompound(String name) {
        CompoundTag tag = this.get(name, CompoundTag.class);
        if (tag == null) {
            tag = new CompoundTag();
            this.put(name, tag);
        }
        return tag;
    }

    public Map<String, Tag<?>> getValue() {
        return this.value == null ? Collections.emptyMap() : this.value;
    }

    public int size() {
        return this.value == null ? 0 : this.value.size();
    }

    @Override
    @NotNull
    public Iterator<Map.Entry<String, Tag<?>>> iterator() {
        return this.value == null ? Collections.emptyIterator() : this.value.entrySet().iterator();
    }
}

