/*
 * Decompiled with CFR 0.152.
 */
package com.hivemc.chunker.nbt.tags.array;

import com.hivemc.chunker.nbt.TagType;
import com.hivemc.chunker.nbt.io.Reader;
import com.hivemc.chunker.nbt.io.Writer;
import com.hivemc.chunker.nbt.tags.Tag;
import java.io.IOException;
import java.util.Arrays;
import java.util.StringJoiner;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LongArrayTag
extends Tag<long[]> {
    public static final int MAX_ARRAY_LENGTH = 65536;
    private long @Nullable [] value;

    public LongArrayTag(long @Nullable [] value) {
        this.value = value;
    }

    public LongArrayTag() {
    }

    @Override
    @NotNull
    public TagType<LongArrayTag, long[]> getType() {
        return TagType.LONG_ARRAY;
    }

    @Override
    protected int valueHashCode() {
        return Arrays.hashCode(this.value);
    }

    @Override
    public boolean valueEquals(long[] boxedValue) {
        return Arrays.equals(this.value, boxedValue) || this.value == null && boxedValue.length == 0 || boxedValue == null && this.value.length == 0;
    }

    @Override
    public boolean valueEquals(Tag<long[]> tag) {
        return this.valueEquals(((LongArrayTag)tag).getValue());
    }

    @Override
    public long[] getBoxedValue() {
        return this.getValue();
    }

    @Override
    public LongArrayTag clone() {
        return new LongArrayTag(this.value == null ? null : Arrays.copyOf(this.value, this.value.length));
    }

    @Override
    public void encodeValue(Writer writer) throws IOException {
        if (this.value != null) {
            writer.writeInt(this.value.length);
            for (long entry : this.value) {
                writer.writeLong(entry);
            }
        } else {
            writer.writeInt(0);
        }
    }

    @Override
    public void decodeValue(Reader reader) throws IOException {
        int length = reader.readInt();
        if (length < 0 || length > 65536) {
            throw new IllegalArgumentException("Could not read array with length " + length);
        }
        this.value = new long[length];
        for (int i = 0; i < length; ++i) {
            this.value[i] = reader.readLong();
        }
    }

    @Override
    public String toSNBT() {
        StringJoiner joiner = new StringJoiner(",", "[L;", "]");
        if (this.value != null) {
            for (long value : this.value) {
                joiner.add(value + "l");
            }
        }
        return joiner.toString();
    }

    public long @Nullable [] getValue() {
        return this.value;
    }

    public void setValue(long @Nullable [] value) {
        this.value = value;
    }

    public int length() {
        return this.value == null ? 0 : this.value.length;
    }
}

