/*
 * Decompiled with CFR 0.152.
 */
package com.hivemc.chunker.nbt.tags.array;

import com.hivemc.chunker.nbt.TagType;
import com.hivemc.chunker.nbt.io.Reader;
import com.hivemc.chunker.nbt.io.Writer;
import com.hivemc.chunker.nbt.tags.Tag;
import java.io.IOException;
import java.util.Arrays;
import java.util.StringJoiner;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IntArrayTag
extends Tag<int[]> {
    public static final int MAX_ARRAY_LENGTH = 65536;
    private int @Nullable [] value;

    public IntArrayTag(int @Nullable [] value) {
        this.value = value;
    }

    public IntArrayTag() {
    }

    @Override
    @NotNull
    public TagType<IntArrayTag, int[]> getType() {
        return TagType.INT_ARRAY;
    }

    @Override
    protected int valueHashCode() {
        return Arrays.hashCode(this.value);
    }

    @Override
    public boolean valueEquals(int[] boxedValue) {
        return Arrays.equals(this.value, boxedValue) || this.value == null && boxedValue.length == 0 || boxedValue == null && this.value.length == 0;
    }

    @Override
    public boolean valueEquals(Tag<int[]> tag) {
        return this.valueEquals(((IntArrayTag)tag).getValue());
    }

    @Override
    public int[] getBoxedValue() {
        return this.getValue();
    }

    @Override
    public IntArrayTag clone() {
        return new IntArrayTag(this.value == null ? null : Arrays.copyOf(this.value, this.value.length));
    }

    @Override
    public void encodeValue(Writer writer) throws IOException {
        if (this.value != null) {
            writer.writeInt(this.value.length);
            for (int entry : this.value) {
                writer.writeInt(entry);
            }
        } else {
            writer.writeInt(0);
        }
    }

    @Override
    public void decodeValue(Reader reader) throws IOException {
        int length = reader.readInt();
        if (length < 0 || length > 65536) {
            throw new IllegalArgumentException("Could not read array with length " + length);
        }
        this.value = new int[length];
        for (int i = 0; i < length; ++i) {
            this.value[i] = reader.readInt();
        }
    }

    @Override
    public String toSNBT() {
        StringJoiner joiner = new StringJoiner(",", "[I;", "]");
        if (this.value != null) {
            for (int value : this.value) {
                joiner.add(String.valueOf(value));
            }
        }
        return joiner.toString();
    }

    public int @Nullable [] getValue() {
        return this.value;
    }

    public void setValue(int @Nullable [] value) {
        this.value = value;
    }

    public int length() {
        return this.value == null ? 0 : this.value.length;
    }
}

