/*
 * Decompiled with CFR 0.152.
 */
package com.hivemc.chunker.nbt.tags.array;

import com.hivemc.chunker.nbt.TagType;
import com.hivemc.chunker.nbt.io.Reader;
import com.hivemc.chunker.nbt.io.Writer;
import com.hivemc.chunker.nbt.tags.Tag;
import java.io.IOException;
import java.util.Arrays;
import java.util.StringJoiner;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ByteArrayTag
extends Tag<byte[]> {
    public static final int MAX_ARRAY_LENGTH = 65536;
    private byte @Nullable [] value;

    public ByteArrayTag(byte @Nullable [] value) {
        this.value = value;
    }

    public ByteArrayTag() {
    }

    @Override
    @NotNull
    public TagType<ByteArrayTag, byte[]> getType() {
        return TagType.BYTE_ARRAY;
    }

    @Override
    protected int valueHashCode() {
        return Arrays.hashCode(this.value);
    }

    @Override
    public boolean valueEquals(byte[] boxedValue) {
        return Arrays.equals(this.value, boxedValue) || this.value == null && boxedValue.length == 0 || boxedValue == null && this.value.length == 0;
    }

    @Override
    public boolean valueEquals(Tag<byte[]> tag) {
        return this.valueEquals(((ByteArrayTag)tag).getValue());
    }

    @Override
    public byte[] getBoxedValue() {
        return this.getValue();
    }

    @Override
    public ByteArrayTag clone() {
        return new ByteArrayTag(this.value == null ? null : Arrays.copyOf(this.value, this.value.length));
    }

    @Override
    public void encodeValue(Writer writer) throws IOException {
        if (this.value != null) {
            writer.writeInt(this.value.length);
            writer.writeBytes(this.value);
        } else {
            writer.writeInt(0);
        }
    }

    @Override
    public void decodeValue(Reader reader) throws IOException {
        int length = reader.readInt();
        if (length < 0 || length > 65536) {
            throw new IllegalArgumentException("Could not read array with length " + length);
        }
        this.value = new byte[length];
        reader.readBytes(this.value);
    }

    @Override
    public String toSNBT() {
        StringJoiner joiner = new StringJoiner(",", "[B;", "]");
        if (this.value != null) {
            for (byte value : this.value) {
                joiner.add(value + "b");
            }
        }
        return joiner.toString();
    }

    public byte @Nullable [] getValue() {
        return this.value;
    }

    public void setValue(byte @Nullable [] value) {
        this.value = value;
    }

    public int length() {
        return this.value == null ? 0 : this.value.length;
    }
}

