/*
 * Decompiled with CFR 0.152.
 */
package com.hivemc.chunker.nbt.tags;

import com.hivemc.chunker.nbt.TagType;
import com.hivemc.chunker.nbt.io.Reader;
import com.hivemc.chunker.nbt.io.Writer;
import com.hivemc.chunker.nbt.tags.TagWithName;
import com.hivemc.chunker.nbt.tags.collection.CompoundTag;
import com.hivemc.chunker.util.ByteBufferInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.GZIPOutputStream;
import net.jpountz.lz4.LZ4BlockOutputStream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class Tag<T> {
    public static byte[] writeBedrockNBT(CompoundTag root) throws IOException {
        try (ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(1024);){
            try (BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(byteArrayOutputStream);
                 DataOutputStream writerStream = new DataOutputStream(bufferedOutputStream);){
                Tag.encodeNamed(Writer.toBedrockWriter(writerStream), "", root);
            }
            byte[] byArray = byteArrayOutputStream.toByteArray();
            return byArray;
        }
    }

    public static void writeBedrockNBT(File file, int storageVersion, CompoundTag root) throws IOException {
        try (FileOutputStream fileOutputStream = new FileOutputStream(file);
             BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(fileOutputStream);
             DataOutputStream writerStream = new DataOutputStream(bufferedOutputStream);){
            Writer writer = Writer.toBedrockWriter(writerStream);
            byte[] bytes = Tag.writeBedrockNBT(root);
            writer.writeInt(storageVersion);
            writer.writeInt(bytes.length);
            writer.writeBytes(bytes);
        }
    }

    public static void writeUncompressedJavaNBT(File file, CompoundTag root) throws IOException {
        try (FileOutputStream fileOutputStream = new FileOutputStream(file);
             BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(fileOutputStream);
             DataOutputStream writerStream = new DataOutputStream(bufferedOutputStream);){
            Tag.encodeNamed(Writer.toJavaWriter(writerStream), "", root);
        }
    }

    public static byte[] writeGZipJavaNBT(CompoundTag root) throws IOException {
        try (ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(1024);){
            try (GZIPOutputStream gzipOutputStream = new GZIPOutputStream(byteArrayOutputStream);
                 BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(gzipOutputStream);
                 DataOutputStream writerStream = new DataOutputStream(bufferedOutputStream);){
                Tag.encodeNamed(Writer.toJavaWriter(writerStream), "", root);
            }
            byte[] byArray = byteArrayOutputStream.toByteArray();
            return byArray;
        }
    }

    public static void writeGZipJavaNBT(File file, CompoundTag root) throws IOException {
        try (FileOutputStream fileOutputStream = new FileOutputStream(file);
             GZIPOutputStream gzipOutputStream = new GZIPOutputStream(fileOutputStream);
             BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(gzipOutputStream);
             DataOutputStream writerStream = new DataOutputStream(bufferedOutputStream);){
            Tag.encodeNamed(Writer.toJavaWriter(writerStream), "", root);
            writerStream.flush();
        }
    }

    public static byte[] writeUncompressedJavaNBT(CompoundTag root) throws IOException {
        try (ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(1024);){
            try (BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(byteArrayOutputStream);
                 DataOutputStream writerStream = new DataOutputStream(bufferedOutputStream);){
                Tag.encodeNamed(Writer.toJavaWriter(writerStream), "", root);
            }
            byte[] byArray = byteArrayOutputStream.toByteArray();
            return byArray;
        }
    }

    public static byte[] writeZLibJavaNBT(CompoundTag root) throws IOException {
        try (ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(1024);){
            try (DeflaterOutputStream deflaterOutputStream = new DeflaterOutputStream((OutputStream)byteArrayOutputStream, new Deflater(1));
                 BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(deflaterOutputStream);
                 DataOutputStream writerStream = new DataOutputStream(bufferedOutputStream);){
                Tag.encodeNamed(Writer.toJavaWriter(writerStream), "", root);
            }
            byte[] byArray = byteArrayOutputStream.toByteArray();
            return byArray;
        }
    }

    public static byte[] writeLZ4JavaNBT(CompoundTag root) throws IOException {
        try (ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(1024);){
            try (LZ4BlockOutputStream lz4OutputStream = new LZ4BlockOutputStream(byteArrayOutputStream);
                 BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(lz4OutputStream);
                 DataOutputStream writerStream = new DataOutputStream(bufferedOutputStream);){
                Tag.encodeNamed(Writer.toJavaWriter(writerStream), "", root);
            }
            byte[] byArray = byteArrayOutputStream.toByteArray();
            return byArray;
        }
    }

    public static void writeZLibJavaNBT(File file, CompoundTag root) throws IOException {
        try (FileOutputStream fileOutputStream = new FileOutputStream(file);
             DeflaterOutputStream deflaterOutputStream = new DeflaterOutputStream((OutputStream)fileOutputStream, new Deflater(1));
             BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(deflaterOutputStream);
             DataOutputStream writerStream = new DataOutputStream(bufferedOutputStream);){
            Tag.encodeNamed(Writer.toJavaWriter(writerStream), "", root);
        }
    }

    public static void encodeNamed(Writer writer, String name, Tag<?> tag) throws IOException {
        writer.writeByte((tag == null ? TagType.END : tag.getType()).getId());
        if (tag != null) {
            writer.writeString(name == null ? "" : name);
            tag.encodeValue(writer);
        }
    }

    public static void encode(Writer writer, @Nullable Tag<?> tag) throws IOException {
        writer.writeByte((tag == null ? TagType.END : tag.getType()).getId());
        if (tag != null) {
            tag.encodeValue(writer);
        }
    }

    /*
     * Exception decompiling
     */
    @Nullable
    public static CompoundTag readBedrockNBT(File file) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Nullable
    public static CompoundTag readBedrockNBT(byte[] input) throws IOException {
        try (ByteArrayInputStream fileInputStream = new ByteArrayInputStream(input);){
            TagWithName<CompoundTag> pair;
            DataInputStream readerStream;
            block12: {
                CompoundTag compoundTag;
                readerStream = new DataInputStream(fileInputStream);
                try {
                    pair = Tag.decodeNamed(Reader.toBedrockReader(readerStream), CompoundTag.class);
                    if (pair != null) break block12;
                    compoundTag = null;
                }
                catch (Throwable throwable) {
                    try {
                        readerStream.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                readerStream.close();
                return compoundTag;
            }
            CompoundTag compoundTag = pair.tag();
            readerStream.close();
            return compoundTag;
        }
    }

    @Nullable
    public static CompoundTag readBedrockNBT(ByteBuffer input) throws IOException {
        try (ByteBufferInputStream fileInputStream = new ByteBufferInputStream(input);){
            TagWithName<CompoundTag> pair;
            DataInputStream readerStream;
            block12: {
                CompoundTag compoundTag;
                readerStream = new DataInputStream(fileInputStream);
                try {
                    pair = Tag.decodeNamed(Reader.toBedrockReader(readerStream), CompoundTag.class);
                    if (pair != null) break block12;
                    compoundTag = null;
                }
                catch (Throwable throwable) {
                    try {
                        readerStream.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                readerStream.close();
                return compoundTag;
            }
            CompoundTag compoundTag = pair.tag();
            readerStream.close();
            return compoundTag;
        }
    }

    /*
     * Exception decompiling
     */
    @Nullable
    public static CompoundTag readUncompressedJavaNBT(byte[] input) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    @Nullable
    public static CompoundTag readUncompressedJavaNBT(File file) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    @Nullable
    public static CompoundTag readLZ4JavaNBT(byte[] input) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    @Nullable
    public static CompoundTag readGZipJavaNBT(byte[] input) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    @Nullable
    public static CompoundTag readGZipJavaNBT(File file) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Nullable
    public static CompoundTag readPossibleGZipJavaNBT(File file) throws IOException {
        boolean gzip = false;
        try (FileInputStream fileInputStream = new FileInputStream(file);){
            byte[] firstBytes = new byte[2];
            if (fileInputStream.read(firstBytes) == firstBytes.length) {
                int header = (firstBytes[1] & 0xFF) << 8 | firstBytes[0] & 0xFF;
                gzip = header == 35615;
            }
        }
        if (gzip) {
            return Tag.readGZipJavaNBT(file);
        }
        return Tag.readUncompressedJavaNBT(file);
    }

    /*
     * Exception decompiling
     */
    @Nullable
    public static CompoundTag readZLibJavaNBT(byte[] input) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    @Nullable
    public static CompoundTag readZLibJavaNBT(File file) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Nullable
    public static TagWithName<?> decodeNamed(Reader reader) throws IOException {
        return Tag.decodeNamed(reader, Tag.class);
    }

    @Nullable
    public static <T extends Tag<?>> TagWithName<T> decodeNamed(Reader reader, Class<T> clazz) throws IOException {
        T tag = Tag.decodeTagClass(reader, clazz);
        String name = null;
        if (tag != null) {
            name = reader.readString(256);
            ((Tag)tag).decodeValue(reader);
        }
        return tag == null ? null : new TagWithName<T>(name, tag);
    }

    @Nullable
    public static Tag<?> decode(Reader reader) throws IOException {
        return Tag.decode(reader, Tag.class);
    }

    @Nullable
    public static <T extends Tag<?>> T decode(Reader reader, Class<T> clazz) throws IOException {
        T tag = Tag.decodeTagClass(reader, clazz);
        if (tag != null) {
            ((Tag)tag).decodeValue(reader);
        }
        return tag;
    }

    @Nullable
    public static Tag<?> decodeTagClass(Reader reader) throws IOException {
        return Tag.decodeTagClass(reader, Tag.class);
    }

    @Nullable
    public static <T extends Tag<?>> T decodeTagClass(Reader reader, Class<T> clazz) throws IOException {
        int tagId = reader.readUnsignedByte();
        TagType<?, ?> tagType = TagType.getById(tagId);
        if (tagType == TagType.END) {
            return null;
        }
        Supplier<?> constructor = tagType.getConstructor();
        Tag tag = (Tag)Objects.requireNonNull(constructor).get();
        return (T)((Tag)clazz.cast(tag));
    }

    @NotNull
    public abstract TagType<? extends Tag<T>, ? super T> getType();

    public final int hashCode() {
        return this.valueHashCode();
    }

    public final boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        Tag tag = (Tag)obj;
        return this.valueEquals(tag);
    }

    protected int valueHashCode() {
        return Objects.hashCode(this.getBoxedValue());
    }

    public boolean valueEquals(T boxedValue) {
        return Objects.equals(this.getBoxedValue(), boxedValue);
    }

    public abstract boolean valueEquals(Tag<T> var1);

    public abstract Tag<T> clone();

    public abstract T getBoxedValue();

    public abstract void encodeValue(Writer var1) throws IOException;

    public abstract void decodeValue(Reader var1) throws IOException;

    public abstract String toSNBT();

    public String toString() {
        return this.toSNBT();
    }
}

