/*
 * Decompiled with CFR 0.152.
 */
package com.hivemc.chunker.nbt.io;

import com.hivemc.chunker.nbt.io.DataInputReaderBE;
import com.hivemc.chunker.nbt.io.DataInputReaderLE;
import java.io.DataInput;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import org.jetbrains.annotations.NotNull;

public interface Reader {
    public static Reader toBigEndianReader(DataInput dataInput) {
        return new DataInputReaderBE(dataInput);
    }

    public static Reader toJavaReader(DataInput dataInput) {
        return Reader.toBigEndianReader(dataInput);
    }

    public static Reader toLittleEndianReader(DataInput dataInput) {
        return new DataInputReaderLE(dataInput);
    }

    public static Reader toBedrockReader(DataInput dataInput) {
        return Reader.toLittleEndianReader(dataInput);
    }

    default public byte[] readShortPrefixedBytes(int maxLength) throws IOException {
        short length = this.readShort();
        if (length < 0 || length > maxLength) {
            throw new IllegalArgumentException("Could not read String with length " + length);
        }
        byte[] bytes = new byte[length];
        this.readBytes(bytes);
        return bytes;
    }

    @NotNull
    default public String readString(int maxLength) throws IOException {
        return new String(this.readShortPrefixedBytes(maxLength), StandardCharsets.UTF_8);
    }

    public short readShort() throws IOException;

    public void readBytes(byte @NotNull [] var1) throws IOException;

    public byte readByte() throws IOException;

    public int readUnsignedByte() throws IOException;

    public int readInt() throws IOException;

    public int readUnsignedInt24() throws IOException;

    public long readLong() throws IOException;

    public float readFloat() throws IOException;

    public double readDouble() throws IOException;
}

