/*
 * Decompiled with CFR 0.152.
 */
package com.hivemc.chunker.nbt.io;

import com.hivemc.chunker.nbt.io.Reader;
import java.io.DataInput;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;

class DataInputReaderLE
implements Reader {
    private final DataInput dataInput;

    protected DataInputReaderLE(DataInput dataInput) {
        this.dataInput = dataInput;
    }

    @Override
    public short readShort() throws IOException {
        byte byte1 = this.dataInput.readByte();
        byte byte2 = this.dataInput.readByte();
        return (short)(byte1 & 0xFF | byte2 << 8);
    }

    @Override
    public void readBytes(byte @NotNull [] array) throws IOException {
        this.dataInput.readFully(array);
    }

    @Override
    public byte readByte() throws IOException {
        return this.dataInput.readByte();
    }

    @Override
    public int readUnsignedByte() throws IOException {
        return this.dataInput.readUnsignedByte();
    }

    @Override
    public int readInt() throws IOException {
        byte byte1 = this.dataInput.readByte();
        byte byte2 = this.dataInput.readByte();
        byte byte3 = this.dataInput.readByte();
        byte byte4 = this.dataInput.readByte();
        return (byte4 & 0xFF) << 24 | (byte3 & 0xFF) << 16 | (byte2 & 0xFF) << 8 | byte1 & 0xFF;
    }

    @Override
    public int readUnsignedInt24() throws IOException {
        byte byte1 = this.dataInput.readByte();
        byte byte2 = this.dataInput.readByte();
        byte byte3 = this.dataInput.readByte();
        return (byte3 & 0xFF) << 16 | (byte2 & 0xFF) << 8 | byte1 & 0xFF;
    }

    @Override
    public long readLong() throws IOException {
        byte byte1 = this.dataInput.readByte();
        byte byte2 = this.dataInput.readByte();
        byte byte3 = this.dataInput.readByte();
        byte byte4 = this.dataInput.readByte();
        byte byte5 = this.dataInput.readByte();
        byte byte6 = this.dataInput.readByte();
        byte byte7 = this.dataInput.readByte();
        byte byte8 = this.dataInput.readByte();
        return ((long)byte8 & 0xFFL) << 56 | ((long)byte7 & 0xFFL) << 48 | ((long)byte6 & 0xFFL) << 40 | ((long)byte5 & 0xFFL) << 32 | ((long)byte4 & 0xFFL) << 24 | ((long)byte3 & 0xFFL) << 16 | ((long)byte2 & 0xFFL) << 8 | (long)byte1 & 0xFFL;
    }

    @Override
    public float readFloat() throws IOException {
        return Float.intBitsToFloat(this.readInt());
    }

    @Override
    public double readDouble() throws IOException {
        return Double.longBitsToDouble(this.readLong());
    }
}

