/*
 * Decompiled with CFR 0.152.
 */
package com.hivemc.chunker.nbt;

import com.hivemc.chunker.nbt.tags.Tag;
import com.hivemc.chunker.nbt.tags.array.ByteArrayTag;
import com.hivemc.chunker.nbt.tags.array.IntArrayTag;
import com.hivemc.chunker.nbt.tags.array.LongArrayTag;
import com.hivemc.chunker.nbt.tags.collection.CompoundTag;
import com.hivemc.chunker.nbt.tags.collection.ListTag;
import com.hivemc.chunker.nbt.tags.primitive.ByteTag;
import com.hivemc.chunker.nbt.tags.primitive.DoubleTag;
import com.hivemc.chunker.nbt.tags.primitive.FloatTag;
import com.hivemc.chunker.nbt.tags.primitive.IntTag;
import com.hivemc.chunker.nbt.tags.primitive.LongTag;
import com.hivemc.chunker.nbt.tags.primitive.ShortTag;
import com.hivemc.chunker.nbt.tags.primitive.StringTag;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import org.jetbrains.annotations.Nullable;

public class TagType<T extends Tag<U>, U> {
    private static final List<TagType<?, ?>> VALUES = new ArrayList(13);
    public static final TagType<Tag<Void>, Void> END = new TagType(null, null, null);
    public static final TagType<ByteTag, Byte> BYTE = new TagType<ByteTag, Byte>(ByteTag.class, ByteTag::new, ByteTag::new);
    public static final TagType<ShortTag, Short> SHORT = new TagType<ShortTag, Short>(ShortTag.class, ShortTag::new, ShortTag::new);
    public static final TagType<IntTag, Integer> INT = new TagType<IntTag, Integer>(IntTag.class, IntTag::new, IntTag::new);
    public static final TagType<LongTag, Long> LONG = new TagType<LongTag, Long>(LongTag.class, LongTag::new, LongTag::new);
    public static final TagType<FloatTag, Float> FLOAT = new TagType<FloatTag, Float>(FloatTag.class, FloatTag::new, FloatTag::new);
    public static final TagType<DoubleTag, Double> DOUBLE = new TagType<DoubleTag, Double>(DoubleTag.class, DoubleTag::new, DoubleTag::new);
    public static final TagType<ByteArrayTag, byte[]> BYTE_ARRAY = new TagType<ByteArrayTag, byte[]>(ByteArrayTag.class, ByteArrayTag::new, ByteArrayTag::new);
    public static final TagType<StringTag, String> STRING = new TagType<StringTag, String>(StringTag.class, StringTag::new, StringTag::new);
    public static final TagType<ListTag<Tag<Object>, Object>, List<Tag<Object>>> LIST = new TagType<ListTag, List>(ListTag.class, ListTag::new, ListTag::new);
    public static final TagType<CompoundTag, Map<String, Tag<?>>> COMPOUND = new TagType<CompoundTag, Map>(CompoundTag.class, CompoundTag::new, CompoundTag::new);
    public static final TagType<IntArrayTag, int[]> INT_ARRAY = new TagType<IntArrayTag, int[]>(IntArrayTag.class, IntArrayTag::new, IntArrayTag::new);
    public static final TagType<LongArrayTag, long[]> LONG_ARRAY = new TagType<LongArrayTag, long[]>(LongArrayTag.class, LongArrayTag::new, LongArrayTag::new);
    private final Class<T> tagClass;
    private final Supplier<T> constructor;
    private final Function<U, T> valueConstructor;
    private final int ordinal;

    private TagType(Class<T> tagClass, Supplier<T> constructor, Function<U, T> valueConstructor) {
        this.tagClass = tagClass;
        this.constructor = constructor;
        this.valueConstructor = valueConstructor;
        this.ordinal = VALUES.size();
        VALUES.add(this);
    }

    @Nullable
    public Class<T> getTagClass() {
        return this.tagClass;
    }

    @Nullable
    public Supplier<T> getConstructor() {
        return this.constructor;
    }

    public Function<U, T> getValueConstructor() {
        return this.valueConstructor;
    }

    public int getId() {
        return this.ordinal;
    }

    public static TagType<?, ?> getById(int id) {
        if (id < 0 || id >= VALUES.size()) {
            throw new IllegalArgumentException("Unknown tag type " + id);
        }
        return VALUES.get(id);
    }

    public static TagType<?, ?>[] values() {
        return (TagType[])VALUES.toArray(TagType[]::new);
    }
}

