/*
 * Decompiled with CFR 0.152.
 */
package com.hivemc.chunker.mapping.resolver;

import com.hivemc.chunker.mapping.MappingsFile;
import com.hivemc.chunker.mapping.identifier.Identifier;
import com.hivemc.chunker.resolver.Resolver;
import java.util.Optional;
import java.util.function.BiFunction;

public class MappingsFileIdentifierResolver
implements Resolver<Identifier, Identifier> {
    private final MappingsFile mappings;
    private final MappingsFile inverseMappings;
    private final BiFunction<MappingsFile, Identifier, Optional<Identifier>> conversionFunction;

    public MappingsFileIdentifierResolver(MappingsFile mappings, MappingsFile inverseMappings, BiFunction<MappingsFile, Identifier, Optional<Identifier>> conversionFunction) {
        this.mappings = mappings;
        this.inverseMappings = inverseMappings;
        this.conversionFunction = conversionFunction;
    }

    @Override
    public Optional<Identifier> to(Identifier input) {
        return this.conversionFunction.apply(this.mappings, input);
    }

    @Override
    public Optional<Identifier> from(Identifier input) {
        return this.conversionFunction.apply(this.inverseMappings, input);
    }
}

