/*
 * Decompiled with CFR 0.152.
 */
package com.hivemc.chunker.mapping.mappings;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.hivemc.chunker.mapping.identifier.states.StateValue;
import com.hivemc.chunker.mapping.mappings.StateMapping;
import com.hivemc.chunker.mapping.mappings.TypeMappings;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;

public class StateMappings {
    private final String name;
    private final List<StateMapping> mappings;

    public StateMappings(String name, List<StateMapping> mappings) {
        this.name = name;
        this.mappings = mappings;
    }

    public static StateMappings deserialize(String name, Map<String, TypeMappings> types, JsonElement jsonElement, JsonDeserializationContext context) throws JsonParseException {
        JsonArray jsonArray = jsonElement.getAsJsonArray();
        ArrayList<StateMapping> list = new ArrayList<StateMapping>(jsonArray.size());
        for (JsonElement element : jsonArray) {
            StateMapping mapping = StateMapping.deserialize(types, element, context);
            list.add(mapping);
        }
        return new StateMappings(name, list);
    }

    public String getName() {
        return this.name;
    }

    public List<StateMapping> getMappings() {
        return this.mappings;
    }

    public StateMappings inverse(Function<TypeMappings, TypeMappings> inverseTypeMappingLookup) {
        ArrayList<StateMapping> inverseMappings = new ArrayList<StateMapping>(this.mappings.size());
        for (StateMapping mapping : this.mappings) {
            inverseMappings.add(mapping.inverse(inverseTypeMappingLookup));
        }
        return new StateMappings(this.name, inverseMappings);
    }

    public String toString() {
        return "StateMappings{name='" + this.name + "', mappings=" + String.valueOf(this.mappings) + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StateMappings that = (StateMappings)o;
        return Objects.equals(this.mappings, that.mappings);
    }

    public int hashCode() {
        return Objects.hash(this.mappings);
    }

    public void apply(Map<String, StateValue<?>> inputStates, Map<String, StateValue<?>> outputStates) {
        for (StateMapping mapping : this.mappings) {
            mapping.apply(inputStates, outputStates);
        }
    }

    public JsonElement serialize(JsonSerializationContext context) {
        JsonArray jsonArray = new JsonArray(this.mappings.size());
        for (StateMapping mapping : this.mappings) {
            jsonArray.add(mapping.serialize(context));
        }
        return jsonArray;
    }
}

