/*
 * Decompiled with CFR 0.152.
 */
package com.hivemc.chunker.mapping.mappings;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.reflect.TypeToken;
import com.hivemc.chunker.mapping.identifier.states.StateValue;
import com.hivemc.chunker.mapping.mappings.StateMappings;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.SortedMap;

public class IdentifierMapping {
    private static final Type STATE_VALUE_MAP_TYPE = new TypeToken<SortedMap<String, StateValue<?>>>(){}.getType();
    private final int index;
    private final String oldIdentifier;
    private final String newIdentifier;
    private final SortedMap<String, StateValue<?>> oldStateValues;
    private final SortedMap<String, StateValue<?>> newStateValues;
    private final StateMappings stateMapping;

    public IdentifierMapping(int index, String oldIdentifier, String newIdentifier, SortedMap<String, StateValue<?>> oldStateValues, SortedMap<String, StateValue<?>> newStateValues, StateMappings stateMapping) {
        this.index = index;
        this.oldIdentifier = oldIdentifier;
        this.newIdentifier = newIdentifier;
        this.oldStateValues = oldStateValues;
        this.newStateValues = newStateValues;
        this.stateMapping = stateMapping;
    }

    public static IdentifierMapping deserialize(Map<String, StateMappings> stateMappings, int index, JsonElement jsonElement, JsonDeserializationContext context) throws JsonParseException {
        StateMappings stateMapping;
        String stateListName;
        JsonObject object = jsonElement.getAsJsonObject();
        String oldIdentifier = object.get("old_identifier").getAsString();
        String newIdentifier = object.has("new_identifier") ? object.get("new_identifier").getAsString() : oldIdentifier;
        SortedMap oldStateValues = object.has("old_state_values") ? (SortedMap)context.deserialize(object.get("old_state_values"), STATE_VALUE_MAP_TYPE) : Collections.emptySortedMap();
        SortedMap newStateValues = object.has("new_state_values") ? (SortedMap)context.deserialize(object.get("new_state_values"), STATE_VALUE_MAP_TYPE) : Collections.emptySortedMap();
        String string = stateListName = object.has("state_list") ? object.get("state_list").getAsString() : null;
        if (stateListName == null || stateListName.isEmpty()) {
            stateMapping = new StateMappings("", Collections.emptyList());
        } else if (stateListName.equals("*")) {
            stateMapping = null;
        } else {
            stateMapping = stateMappings.get(stateListName);
            if (stateMapping == null) {
                throw new JsonParseException("Could not find state_list " + stateListName);
            }
        }
        return new IdentifierMapping(index, oldIdentifier, newIdentifier, oldStateValues, newStateValues, stateMapping);
    }

    public int getIndex() {
        return this.index;
    }

    public String getNewIdentifier() {
        return this.newIdentifier;
    }

    public SortedMap<String, StateValue<?>> getNewStateValues() {
        return this.newStateValues;
    }

    public StateMappings getStateMapping() {
        return this.stateMapping;
    }

    public String getOldIdentifier() {
        return this.oldIdentifier;
    }

    public SortedMap<String, StateValue<?>> getOldStateValues() {
        return this.oldStateValues;
    }

    public String toString() {
        return "IdentifierMapping{index=" + this.index + ", oldIdentifier='" + this.oldIdentifier + "', newIdentifier='" + this.newIdentifier + "', oldStateValues=" + String.valueOf(this.oldStateValues) + ", newStateValues=" + String.valueOf(this.newStateValues) + ", stateMapping=" + String.valueOf(this.stateMapping) + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IdentifierMapping that = (IdentifierMapping)o;
        return this.index == that.index && Objects.equals(this.oldIdentifier, that.oldIdentifier) && Objects.equals(this.newIdentifier, that.newIdentifier) && Objects.equals(this.oldStateValues, that.oldStateValues) && Objects.equals(this.newStateValues, that.newStateValues) && Objects.equals(this.stateMapping, that.stateMapping);
    }

    public int hashCode() {
        return Objects.hash(this.index, this.oldIdentifier, this.newIdentifier, this.oldStateValues, this.newStateValues, this.stateMapping);
    }

    public JsonElement serialize(JsonSerializationContext context) {
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("old_identifier", this.oldIdentifier);
        if (!this.oldIdentifier.equals(this.newIdentifier)) {
            jsonObject.addProperty("new_identifier", this.newIdentifier);
        }
        if (!this.oldStateValues.isEmpty()) {
            jsonObject.add("old_state_values", context.serialize(this.oldStateValues, STATE_VALUE_MAP_TYPE));
        }
        if (!this.newStateValues.isEmpty()) {
            jsonObject.add("new_state_values", context.serialize(this.newStateValues, STATE_VALUE_MAP_TYPE));
        }
        if (this.getStateMapping() != null) {
            jsonObject.addProperty("state_list", this.getStateMapping().getName());
        }
        return jsonObject;
    }
}

