/*
 * Decompiled with CFR 0.152.
 */
package com.hivemc.chunker.mapping.identifier.states;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.reflect.TypeToken;
import com.hivemc.chunker.mapping.identifier.states.StateValueBoolean;
import com.hivemc.chunker.mapping.identifier.states.StateValueInt;
import com.hivemc.chunker.mapping.identifier.states.StateValueString;
import com.hivemc.chunker.nbt.tags.Tag;
import com.hivemc.chunker.nbt.tags.primitive.ByteTag;
import com.hivemc.chunker.nbt.tags.primitive.IntTag;
import com.hivemc.chunker.nbt.tags.primitive.StringTag;
import java.lang.reflect.Type;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public interface StateValue<T> {
    public static <T> StateValue<T> fromBoxed(@NotNull T input) {
        if (input instanceof Boolean) {
            Boolean bool = (Boolean)input;
            return bool != false ? StateValueBoolean.TRUE : StateValueBoolean.FALSE;
        }
        if (input instanceof String) {
            String string = (String)input;
            return new StateValueString(string);
        }
        if (input instanceof Number) {
            Number number = (Number)input;
            return new StateValueInt(number.intValue());
        }
        throw new IllegalArgumentException("Unable to unbox value of type " + String.valueOf(input.getClass()));
    }

    public static <T> StateValue<?> fromNBT(@NotNull Tag<T> input) {
        if (input instanceof ByteTag) {
            ByteTag bool = (ByteTag)input;
            return bool.getValue() == 1 ? StateValueBoolean.TRUE : StateValueBoolean.FALSE;
        }
        if (input instanceof StringTag) {
            StringTag stringTag = (StringTag)input;
            return new StateValueString(stringTag.getValue());
        }
        if (input instanceof IntTag) {
            IntTag intTag = (IntTag)input;
            return new StateValueInt(intTag.getValue());
        }
        throw new IllegalArgumentException("Unable to decode tag value of type " + String.valueOf(input.getClass()));
    }

    public T getBoxed();

    public Tag<?> toNBT();

    public static class Adapter
    implements JsonSerializer<StateValue<?>>,
    JsonDeserializer<StateValue<?>> {
        private static final Type STATE_VALUE_LIST_TYPE = new TypeToken<List<StateValue<?>>>(){}.getType();

        public static JsonElement serializeStateValues(List<StateValue<?>> input, JsonSerializationContext context) throws JsonParseException {
            if (input.size() == 1) {
                return context.serialize(input.iterator().next(), (Type)((Object)StateValue.class));
            }
            return context.serialize(input, STATE_VALUE_LIST_TYPE);
        }

        public static List<StateValue<?>> deserializeStateValues(JsonElement jsonElement, JsonDeserializationContext context) throws JsonParseException {
            if (jsonElement.isJsonArray()) {
                return (List)context.deserialize(jsonElement, STATE_VALUE_LIST_TYPE);
            }
            return List.of((StateValue)context.deserialize(jsonElement, (Type)((Object)StateValue.class)));
        }

        @Override
        public JsonElement serialize(StateValue stateValue, Type type, JsonSerializationContext context) {
            if (stateValue instanceof StateValueBoolean) {
                StateValueBoolean stateValueBoolean = (StateValueBoolean)stateValue;
                return new JsonPrimitive(stateValueBoolean.getValue());
            }
            if (stateValue instanceof StateValueString) {
                StateValueString stateValueString = (StateValueString)stateValue;
                return new JsonPrimitive(stateValueString.getValue());
            }
            if (stateValue instanceof StateValueInt) {
                StateValueInt stateValueInt = (StateValueInt)stateValue;
                return new JsonPrimitive(stateValueInt.getValue());
            }
            throw new IllegalArgumentException("Unable to serialize " + String.valueOf(type));
        }

        @Override
        public StateValue<?> deserialize(JsonElement jsonElement, Type type, JsonDeserializationContext context) throws JsonParseException {
            if (jsonElement.isJsonPrimitive()) {
                JsonPrimitive primitive = jsonElement.getAsJsonPrimitive();
                if (primitive.isBoolean()) {
                    return primitive.getAsBoolean() ? StateValueBoolean.TRUE : StateValueBoolean.FALSE;
                }
                if (primitive.isString()) {
                    return new StateValueString(primitive.getAsString());
                }
                if (primitive.isNumber()) {
                    return new StateValueInt(primitive.getAsInt());
                }
            }
            throw new JsonParseException("Unknown type for " + String.valueOf(jsonElement));
        }
    }
}

