/*
 * Decompiled with CFR 0.152.
 */
package com.hivemc.chunker.conversion.intermediate.level.map;

import com.hivemc.chunker.conversion.intermediate.world.Dimension;
import com.hivemc.chunker.nbt.tags.collection.CompoundTag;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.Comparator;
import javax.imageio.ImageIO;
import org.jetbrains.annotations.Nullable;

public class ChunkerMap {
    public static final Comparator<ChunkerMap> BY_ID_COMPARATOR = Comparator.comparing(ChunkerMap::getId);
    private final Long originalId;
    private long id;
    private int width;
    private int height;
    private byte scale;
    private Dimension dimension;
    private int xCenter;
    private int zCenter;
    private boolean unlimitedTracking;
    private boolean locked;
    private transient byte @Nullable [] bytes;
    @Nullable
    private transient CompoundTag originalNBT;

    public ChunkerMap(long originalId, long id, int width, int height, byte scale, Dimension dimension, int xCenter, int zCenter, boolean unlimitedTracking, boolean locked, byte @Nullable [] bytes, @Nullable CompoundTag originalNBT) {
        this.originalId = originalId;
        this.id = id;
        this.width = width;
        this.height = height;
        this.scale = scale;
        this.dimension = dimension;
        this.xCenter = xCenter;
        this.zCenter = zCenter;
        this.unlimitedTracking = unlimitedTracking;
        this.locked = locked;
        this.bytes = bytes;
        this.originalNBT = originalNBT;
    }

    public ChunkerMap(long id, int width, int height, byte scale, Dimension dimension, int xCenter, int zCenter, boolean unlimitedTracking, boolean locked, byte @Nullable [] bytes) {
        this.originalId = null;
        this.id = id;
        this.width = width;
        this.height = height;
        this.scale = scale;
        this.dimension = dimension;
        this.xCenter = xCenter;
        this.zCenter = zCenter;
        this.unlimitedTracking = unlimitedTracking;
        this.locked = locked;
        this.bytes = bytes;
    }

    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    @Nullable
    public Long getOriginalId() {
        return this.originalId;
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public int getHeight() {
        return this.height;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public byte getScale() {
        return this.scale;
    }

    public void setScale(byte scale) {
        this.scale = scale;
    }

    public Dimension getDimension() {
        return this.dimension;
    }

    public void setDimension(Dimension dimension) {
        this.dimension = dimension;
    }

    public int getXCenter() {
        return this.xCenter;
    }

    public void setXCenter(int xCenter) {
        this.xCenter = xCenter;
    }

    public int getZCenter() {
        return this.zCenter;
    }

    public void setZCenter(int zCenter) {
        this.zCenter = zCenter;
    }

    public boolean isUnlimitedTracking() {
        return this.unlimitedTracking;
    }

    public void setUnlimitedTracking(boolean unlimitedTracking) {
        this.unlimitedTracking = unlimitedTracking;
    }

    public boolean isLocked() {
        return this.locked;
    }

    public void setLocked(boolean locked) {
        this.locked = locked;
    }

    public byte @Nullable [] getBytes() {
        return this.bytes;
    }

    public void setBytes(byte @Nullable [] bytes) {
        this.bytes = bytes;
    }

    public void loadImage(File file) throws IOException {
        if (!file.exists()) {
            throw new IllegalArgumentException("Could not find map file " + file.getName());
        }
        BufferedImage inputImage = ImageIO.read(file);
        if (inputImage.getWidth() != this.width || inputImage.getHeight() != this.height) {
            BufferedImage outputImage = new BufferedImage(this.width, this.height, 2);
            Graphics2D g2d = outputImage.createGraphics();
            g2d.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
            g2d.drawImage(inputImage, 0, 0, this.width, this.height, null);
            g2d.dispose();
            inputImage = outputImage;
        }
        byte[] rgba = new byte[this.width * this.height * 4];
        int index = 0;
        for (int y = 0; y < this.height; ++y) {
            for (int x = 0; x < this.width; ++x) {
                int color = inputImage.getRGB(x, y);
                rgba[index] = (byte)(color >> 16 & 0xFF);
                rgba[index + 1] = (byte)(color >> 8 & 0xFF);
                rgba[index + 2] = (byte)(color & 0xFF);
                rgba[index + 3] = (color >> 24 & 0xFF) > 128 ? -1 : 0;
                index += 4;
            }
        }
        this.bytes = rgba;
    }

    @Nullable
    public CompoundTag getOriginalNBT() {
        return this.originalNBT;
    }

    public void setOriginalNBT(@Nullable CompoundTag originalNBT) {
        this.originalNBT = originalNBT;
    }
}

